/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.oreveins.world;

import com.alcatrazescapee.oreveins.OreVeinsConfig;
import com.alcatrazescapee.oreveins.api.IVein;
import com.alcatrazescapee.oreveins.api.IVeinType;
import com.alcatrazescapee.oreveins.vein.Indicator;
import com.alcatrazescapee.oreveins.vein.VeinRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockHugeMushroom;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenVeins
implements IWorldGenerator {
    private static final Random RANDOM = new Random();
    private static int CHUNK_RADIUS = 0;

    public static void resetChunkRadius() {
        CHUNK_RADIUS = 4 + VeinRegistry.getVeins().stream().mapToInt(IVeinType::getChunkRadius).max().orElse(0) + OreVeinsConfig.EXTRA_CHUNK_SEARCH_RANGE;
    }

    @Nonnull
    public static List<IVein> getNearbyVeins(int chunkX, int chunkZ, long worldSeed, int radius) {
        ArrayList<IVein> veins = new ArrayList<IVein>();
        for (int x = chunkX - radius; x <= chunkX + radius; ++x) {
            for (int z = chunkZ - radius; z <= chunkZ + radius; ++z) {
                RANDOM.setSeed(worldSeed + (long)x * 341873128712L + (long)z * 132897987541L);
                WorldGenVeins.getVeinsAtChunk(veins, x, z, worldSeed);
            }
        }
        return veins;
    }

    private static void getVeinsAtChunk(List<IVein> veins, int chunkX, int chunkZ, long worldSeed) {
        Random random = new Random(worldSeed + (long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        for (IVeinType type : VeinRegistry.getVeins()) {
            for (int i = 0; i < type.getCount(); ++i) {
                if (random.nextInt(type.getRarity()) != 0) continue;
                Object vein = type.createVein(chunkX, chunkZ, random);
                veins.add((IVein)vein);
            }
        }
    }

    private static BlockPos getTopBlockIgnoreVegetation(World world, BlockPos pos) {
        Chunk chunk = world.func_175726_f(pos);
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos(pos.func_177958_n(), chunk.func_76625_h() + 16, pos.func_177952_p());
        while (mPos.func_177956_o() > 0) {
            mPos.func_189534_c(EnumFacing.DOWN, 1);
            IBlockState state = chunk.func_177435_g((BlockPos)mPos);
            if (!state.func_185904_a().func_76230_c() || state.func_177230_c().isLeaves(state, (IBlockAccess)world, (BlockPos)mPos) || state.func_177230_c().isFoliage((IBlockAccess)world, (BlockPos)mPos) || state.func_185904_a().func_76224_d() || state.func_177230_c() instanceof BlockHugeMushroom) continue;
            break;
        }
        return mPos.func_189536_c(EnumFacing.UP).func_185334_h();
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        List<IVein> veins = WorldGenVeins.getNearbyVeins(chunkX, chunkZ, world.func_72905_C(), CHUNK_RADIUS);
        if (veins.isEmpty()) {
            return;
        }
        int xoff = chunkX * 16 + 8;
        int zoff = chunkZ * 16 + 8;
        for (IVein vein : veins) {
            if (!vein.getType().matchesDimension(world.field_73011_w.getDimension())) continue;
            this.generate(world, random, xoff, zoff, vein);
        }
    }

    private void generate(World world, Random random, int xOff, int zOff, IVein<?> vein) {
        for (int x = xOff; x < 16 + xOff; ++x) {
            for (int z = zOff; z < 16 + zOff; ++z) {
                Biome biomeAt = world.func_180494_b(new BlockPos(x, 0, z));
                if (!vein.getType().matchesBiome(biomeAt) || !vein.inRange(x, z)) continue;
                Indicator veinIndicator = vein.getType().getIndicator(random);
                boolean canGenerateIndicator = false;
                for (int y = vein.getType().getMinY(); y <= vein.getType().getMaxY(); ++y) {
                    BlockPos posAt = new BlockPos(x, y, z);
                    if (!((double)random.nextFloat() < vein.getChanceToGenerate(posAt))) continue;
                    if (vein.getType().useRelativeY()) {
                        posAt = WorldGenVeins.getTopBlockIgnoreVegetation(world, posAt).func_177981_b(y);
                    }
                    if (!vein.getType().canGenerateAt(world, posAt)) continue;
                    IBlockState oreState = vein.getType().getStateToGenerate(random);
                    world.func_175656_a(posAt, oreState);
                    if (veinIndicator == null || canGenerateIndicator) continue;
                    int depth = world.func_189649_b(x, z) - y;
                    if (depth < 0) {
                        depth = -depth;
                    }
                    canGenerateIndicator = depth < veinIndicator.getMaxDepth();
                }
                if (veinIndicator == null || !canGenerateIndicator || random.nextInt(veinIndicator.getRarity()) != 0) continue;
                BlockPos posAt = veinIndicator.shouldIgnoreVegetation() ? WorldGenVeins.getTopBlockIgnoreVegetation(world, new BlockPos(x, 0, z)) : new BlockPos(x, world.func_189649_b(x, z), z);
                IBlockState indicatorState = veinIndicator.getStateToGenerate(random);
                IBlockState stateAt = world.func_180495_p(posAt);
                if (!indicatorState.func_177230_c().func_176196_c(world, posAt) || !stateAt.func_177230_c().func_176200_f((IBlockAccess)world, posAt) || !veinIndicator.shouldIgnoreLiquids() && stateAt.func_185904_a().func_76224_d() || !veinIndicator.validUnderState(world.func_180495_p(posAt.func_177977_b()))) continue;
                world.func_175656_a(posAt, indicatorState);
            }
        }
    }
}

