/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.oreveins;

import com.alcatrazescapee.oreveins.util.json.BlockStateDeserializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public final class Config {
    public static final GeneralConfig COMMON;
    private static final ForgeConfigSpec COMMON_SPEC;

    public static void register() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, COMMON_SPEC);
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(GeneralConfig::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (GeneralConfig)specPair.getLeft();
    }

    public static final class GeneralConfig {
        public final ForgeConfigSpec.BooleanValue noOres;
        public final ForgeConfigSpec.BooleanValue debugCommands;
        public final ForgeConfigSpec.IntValue extraChunkRange;
        public final ForgeConfigSpec.BooleanValue enableDefaultVeins;
        public final ForgeConfigSpec.BooleanValue avoidVeinCutoffs;
        private final ForgeConfigSpec.ConfigValue<List<? extends String>> disabledOres;

        GeneralConfig(ForgeConfigSpec.Builder builder) {
            builder.push("general");
            this.noOres = builder.comment("Stop all vanilla ore gen calls? Warning: this includes calls such as andesite/diorite, and potentially others that internally behave the same as ores. For more customization, see the disabled ores option.").define("noOres", true);
            this.disabledOres = builder.comment("Vanilla ore gen to disable. Must be specified as a list of block states, i.e. minecraft:gold_ore, minecraft:iron_ore, etc.").defineList("disabledOres", this::defaultDisabledBlockStates, obj -> BlockStateDeserializer.INSTANCE.isBlockState(obj.toString()));
            this.debugCommands = builder.comment("Enable debug commands such as /veininfo, /clearworld, /findveins").define("debugCommands", true);
            this.extraChunkRange = builder.comment(new String[]{"Extra chunk search range when generating veins", "Use if your veins are getting cut off at chunk boundaries"}).defineInRange("extraChunkRange", 0, 0, 20);
            this.enableDefaultVeins = builder.comment("Enable veins in the default data pack. (This is the 'oreveins:default_veins' condition)").define("enableDefaultVeins", true);
            this.avoidVeinCutoffs = builder.comment("Try to avoid placing veins on the edge of their range as defined by min / max y, so they don't get cut off at the border.").define("avoidVeinCutoffs", true);
            builder.pop();
        }

        public Set<BlockState> disabledBlockStates() {
            return ((List)this.disabledOres.get()).stream().map(BlockStateDeserializer.INSTANCE::readBlockState).collect(Collectors.toSet());
        }

        private List<? extends String> defaultDisabledBlockStates() {
            return new ArrayList<String>(Arrays.asList("minecraft:coal_ore", "minecraft:iron_ore", "minecraft:gold_ore", "minecraft:diamond_ore", "minecraft:lapis_ore", "minecraft:redstone_ore", "minecraft:diamond_ore"));
        }
    }
}

