/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.oreveins;

import com.alcatrazescapee.oreveins.Config;
import com.alcatrazescapee.oreveins.ForgeEventHandler;
import com.alcatrazescapee.oreveins.util.condition.DefaultVeinsCondition;
import com.alcatrazescapee.oreveins.world.AtChunk;
import com.alcatrazescapee.oreveins.world.VanillaFeatureManager;
import com.alcatrazescapee.oreveins.world.VeinsFeature;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="oreveins")
public class OreVeins {
    public static final String MOD_ID = "oreveins";
    private static final Logger LOGGER = LogManager.getLogger();

    public OreVeins() {
        LOGGER.debug("Constructing");
        Config.register();
        CraftingHelper.register((IConditionSerializer)DefaultVeinsCondition.Serializer.INSTANCE);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)ForgeEventHandler.INSTANCE);
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent event) {
        LOGGER.debug("Setup");
        ForgeRegistries.BIOMES.forEach(biome -> {
            ConfiguredFeature feature = Biome.func_222280_a((Feature)new VeinsFeature(), (IFeatureConfig)new NoFeatureConfig(), (Placement)new AtChunk(), (IPlacementConfig)IPlacementConfig.field_202468_e);
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, feature);
        });
        VanillaFeatureManager.onConfigReloading();
    }

    @SubscribeEvent
    public void onLoadConfig(ModConfig.ConfigReloading event) {
        LOGGER.debug("Reloading config - reevaluating vanilla ore vein settings");
        if (event.getConfig().getType() == ModConfig.Type.SERVER) {
            VanillaFeatureManager.onConfigReloading();
        }
    }
}

