/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.oreveins.command;

import com.alcatrazescapee.oreveins.world.vein.VeinManager;
import com.alcatrazescapee.oreveins.world.vein.VeinType;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;

@ParametersAreNonnullByDefault
public final class ClearWorldCommand {
    private static final Set<BlockState> VEIN_STATES = new HashSet<BlockState>();

    public static void resetVeinStates() {
        VeinManager.INSTANCE.getVeins().stream().map(VeinType::getOreStates).forEach(VEIN_STATES::addAll);
    }

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"clearworld").requires(source -> source.func_197034_c(2))).then(Commands.func_197056_a((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)250)).executes(cmd -> ClearWorldCommand.clearWorld((CommandSource)cmd.getSource(), IntegerArgumentType.getInteger((CommandContext)cmd, (String)"radius")))));
    }

    private static int clearWorld(CommandSource source, int radius) {
        ServerWorld world = source.func_197023_e();
        BlockPos center = new BlockPos(source.func_197036_d());
        BlockState air = Blocks.field_150350_a.func_176223_P();
        for (BlockPos pos : BlockPos.MutableBlockPos.func_218278_a((BlockPos)center.func_177982_a(-radius, 255 - center.func_177956_o(), -radius), (BlockPos)center.func_177982_a(radius, -center.func_177956_o(), radius))) {
            if (VEIN_STATES.contains(world.func_180495_p(pos))) continue;
            world.func_180501_a(pos, air, 18);
        }
        source.func_197030_a((ITextComponent)new TranslationTextComponent("oreveins.command.clear_world_done", new Object[0]), true);
        return 1;
    }
}

