/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.oreveins.command;

import com.alcatrazescapee.oreveins.command.VeinTypeArgument;
import com.alcatrazescapee.oreveins.world.VeinsFeature;
import com.alcatrazescapee.oreveins.world.vein.Vein;
import com.alcatrazescapee.oreveins.world.vein.VeinManager;
import com.alcatrazescapee.oreveins.world.vein.VeinType;
import com.google.gson.JsonParseException;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

@ParametersAreNonnullByDefault
public final class FindVeinsCommand {
    private static final String TP_MESSAGE = "{\"text\":\"" + TextFormatting.BLUE + "[Click to Teleport]" + TextFormatting.RESET + "\",\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/tp %d %d %d\"}}";
    public static final SuggestionProvider<CommandSource> VEIN_TYPE_SUGGESTIONS = (context, builder) -> ISuggestionProvider.func_197014_a(VeinManager.INSTANCE.getKeys(), (SuggestionsBuilder)builder);

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"findveins").requires(source -> source.func_197034_c(2))).then(Commands.func_197056_a((String)"type", (ArgumentType)new VeinTypeArgument()).suggests((context, builder) -> ISuggestionProvider.func_197014_a(VeinManager.INSTANCE.getKeys(), (SuggestionsBuilder)builder)).then(Commands.func_197056_a((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)0, (int)250)).executes(cmd -> FindVeinsCommand.findVeins((CommandSource)cmd.getSource(), VeinTypeArgument.getVein(cmd, "type"), IntegerArgumentType.getInteger((CommandContext)cmd, (String)"radius"))))));
    }

    private static int findVeins(CommandSource source, ResourceLocation veinName, int radius) throws CommandSyntaxException {
        BlockPos pos = new BlockPos(source.func_197036_d());
        int chunkX = pos.func_177958_n() >> 4;
        int chunkZ = pos.func_177952_p() >> 4;
        List<Vein<?>> veins = VeinsFeature.getNearbyVeins(chunkX, chunkZ, source.func_197023_e().func_72905_C(), radius);
        VeinType<?> type = VeinManager.INSTANCE.getVein(veinName);
        if (type == null) {
            source.func_197021_a((ITextComponent)new TranslationTextComponent("oreveins.command.unknown_vein", new Object[]{veinName.toString()}));
        }
        veins.removeIf(x -> x.getType() != type);
        source.func_197030_a((ITextComponent)new TranslationTextComponent("oreveins.command.veins_found", new Object[0]), true);
        for (Vein<?> vein : veins) {
            TranslationTextComponent resultText = new TranslationTextComponent("oreveins.command.vein_info", new Object[]{vein.toString()});
            if (!(source.func_197022_f() instanceof PlayerEntity)) continue;
            BlockPos veinPos = vein.getPos();
            try {
                ITextComponent tpText = ITextComponent.Serializer.func_186877_b((String)String.format(TP_MESSAGE, veinPos.func_177958_n(), veinPos.func_177956_o(), veinPos.func_177952_p()));
                if (tpText == null) continue;
                source.func_197022_f().func_145747_a(TextComponentUtils.func_197680_a((CommandSource)source, (ITextComponent)resultText.func_150257_a(tpText), (Entity)source.func_197022_f(), (int)0));
            }
            catch (JsonParseException jsonParseException) {}
        }
        return 1;
    }
}

