/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.oreveins.util.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.Type;
import net.minecraft.block.BlockState;
import net.minecraft.command.arguments.BlockStateParser;

public enum BlockStateDeserializer implements JsonDeserializer<BlockState>
{
    INSTANCE;


    public BlockState deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonPrimitive()) {
            return this.readBlockState(json.getAsString());
        }
        if (json.isJsonObject()) {
            JsonObject jsonObj = json.getAsJsonObject();
            String name = jsonObj.get("block").getAsString();
            return this.readBlockState(name);
        }
        throw new JsonParseException("BlockState must be String or Object");
    }

    public BlockState readBlockState(String block) {
        StringReader reader = new StringReader(block);
        try {
            return new BlockStateParser(reader, true).func_197243_a(false).func_197249_b();
        }
        catch (CommandSyntaxException e) {
            throw new JsonParseException("Unable to parse block state", (Throwable)e);
        }
    }

    public boolean isBlockState(String block) {
        try {
            new BlockStateParser(new StringReader(block), true).func_197243_a(false);
            return true;
        }
        catch (CommandSyntaxException e) {
            return false;
        }
    }
}

