/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.oreveins.util.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;

public class LenientListDeserializer<T, E extends Collection<T>>
implements JsonDeserializer<E> {
    private final Class<T> elementClass;
    private final Function<T, E> singletonSupplier;
    private final Function<Collection<T>, E> listSupplier;

    public LenientListDeserializer(Class<T> elementClass, Function<T, E> singletonSupplier, Function<Collection<T>, E> listSupplier) {
        this.elementClass = elementClass;
        this.singletonSupplier = singletonSupplier;
        this.listSupplier = listSupplier;
    }

    public E deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonArray()) {
            JsonArray array = json.getAsJsonArray();
            ArrayList<Object> elements = new ArrayList<Object>(array.size());
            for (JsonElement element : array) {
                elements.add(context.deserialize(element, this.elementClass));
            }
            return (E)((Collection)this.listSupplier.apply(elements));
        }
        return (E)((Collection)this.singletonSupplier.apply(context.deserialize(json, this.elementClass)));
    }
}

