/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.oreveins.util.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.util.JSONUtils;

public abstract class PredicateDeserializer<E, T extends Predicate<E>>
implements JsonDeserializer<T> {
    private Class<T> elementType;
    private String collectionName;

    public PredicateDeserializer(Class<T> elementType, String collectionName) {
        this.elementType = elementType;
        this.collectionName = collectionName;
    }

    public T deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonObject()) {
            String typeName;
            JsonObject obj = json.getAsJsonObject();
            switch (typeName = JSONUtils.func_151200_h((JsonObject)obj, (String)"type")) {
                case "and": {
                    return this.createCollectionRule(JSONUtils.func_151214_t((JsonObject)obj, (String)this.collectionName), context, false);
                }
                case "or": {
                    return this.createCollectionRule(JSONUtils.func_151214_t((JsonObject)obj, (String)this.collectionName), context, true);
                }
                case "not": {
                    Predicate innerRule = (Predicate)context.deserialize((JsonElement)JSONUtils.func_152754_s((JsonObject)obj, (String)this.collectionName), this.elementType);
                    innerRule.test(null);
                    return this.createPredicate(item -> !innerRule.test(item));
                }
            }
            return this.createSingleRule(obj, typeName);
        }
        if (json.isJsonArray()) {
            return this.createCollectionRule(json.getAsJsonArray(), context, true);
        }
        if (json.isJsonPrimitive()) {
            return this.createSingleRule(json.getAsString());
        }
        throw new JsonParseException("Rule should be an object, array, or string");
    }

    protected T createSingleRule(JsonObject json, String typeName) {
        throw new JsonParseException("Unknown type for rule: " + typeName);
    }

    protected abstract T createSingleRule(String var1);

    protected abstract T createPredicate(Predicate<E> var1);

    private T createCollectionRule(JsonArray array, JsonDeserializationContext context, boolean baseValue) {
        ArrayList<Object> innerRules = new ArrayList<Object>();
        for (JsonElement arrayElement : array) {
            innerRules.add(context.deserialize(arrayElement, this.elementType));
        }
        return this.createPredicate(item -> {
            for (Predicate rule : innerRules) {
                if (rule.test(item) != baseValue) continue;
                return baseValue;
            }
            return !baseValue;
        });
    }
}

