/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.oreveins.util.json;

import com.alcatrazescapee.oreveins.world.vein.ClusterVeinType;
import com.alcatrazescapee.oreveins.world.vein.ConeVeinType;
import com.alcatrazescapee.oreveins.world.vein.CurveVeinType;
import com.alcatrazescapee.oreveins.world.vein.PipeVeinType;
import com.alcatrazescapee.oreveins.world.vein.SphereVeinType;
import com.alcatrazescapee.oreveins.world.vein.VeinType;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.util.JSONUtils;

public enum VeinTypeDeserializer implements JsonDeserializer<VeinType<?>>
{
    INSTANCE;

    private final Map<String, Factory> factories = new HashMap<String, Factory>();

    private VeinTypeDeserializer() {
        this.factories.put("cluster", ClusterVeinType::new);
        this.factories.put("sphere", SphereVeinType::new);
        this.factories.put("cone", ConeVeinType::new);
        this.factories.put("pipe", PipeVeinType::new);
        this.factories.put("curve", CurveVeinType::new);
    }

    public VeinType<?> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject obj = json.getAsJsonObject();
        String veinTypeName = JSONUtils.func_151200_h((JsonObject)obj, (String)"type");
        Factory factory = this.factories.get(veinTypeName);
        if (factory == null) {
            throw new JsonParseException("Unknown Vein Type: " + veinTypeName);
        }
        return factory.create(json.getAsJsonObject(), context);
    }

    static interface Factory {
        @Nonnull
        public VeinType<?> create(JsonObject var1, JsonDeserializationContext var2);
    }
}

