/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.oreveins.util.json;

import com.alcatrazescapee.oreveins.util.IWeightedList;
import com.alcatrazescapee.oreveins.util.WeightedList;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import net.minecraft.util.JSONUtils;

public class WeightedListDeserializer<T>
implements JsonDeserializer<IWeightedList<T>> {
    private final Class<T> elementClass;

    public WeightedListDeserializer(Class<T> elementClass) {
        this.elementClass = elementClass;
    }

    public IWeightedList<T> deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonPrimitive() || json.isJsonObject()) {
            Object state = context.deserialize(json, this.elementClass);
            return IWeightedList.singleton(state);
        }
        if (json.isJsonArray()) {
            JsonArray array = json.getAsJsonArray();
            WeightedList<Object> states = new WeightedList<Object>();
            for (JsonElement element : array) {
                if (element.isJsonObject()) {
                    JsonObject obj = element.getAsJsonObject();
                    float weight = JSONUtils.func_151221_a((JsonObject)obj, (String)"weight", (float)1.0f);
                    states.add(weight, context.deserialize(element, this.elementClass));
                    continue;
                }
                states.add(1.0, context.deserialize(element, this.elementClass));
            }
            return states;
        }
        throw new JsonParseException("Unable to parse Weighted List of " + this.elementClass.getSimpleName());
    }
}

