/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.oreveins.world;

import com.alcatrazescapee.oreveins.Config;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraftforge.registries.ForgeRegistries;

public class VanillaFeatureManager {
    private static final Map<Biome, List<ConfiguredFeature<?>>> DISABLED_FEATURES = new HashMap();
    private static Set<BlockState> disabledBlockStates;
    private static boolean disableAll;

    public static void onConfigReloading() {
        disabledBlockStates = Config.COMMON.disabledBlockStates();
        disableAll = (Boolean)Config.COMMON.noOres.get();
        ForgeRegistries.BIOMES.forEach(biome -> {
            List features = DISABLED_FEATURES.computeIfAbsent((Biome)biome, key -> new ArrayList());
            List toReAdd = features.stream().filter(x -> !VanillaFeatureManager.shouldDisable(x)).collect(Collectors.toList());
            List toRemove = biome.func_203607_a(GenerationStage.Decoration.UNDERGROUND_ORES).stream().filter(VanillaFeatureManager::shouldDisable).collect(Collectors.toList());
            features.addAll(toRemove);
            features.removeAll(toReAdd);
            List currentFeatures = biome.func_203607_a(GenerationStage.Decoration.UNDERGROUND_ORES);
            currentFeatures.addAll(toReAdd);
            currentFeatures.removeAll(toRemove);
        });
    }

    private static boolean shouldDisable(ConfiguredFeature<?> feature) {
        IFeatureConfig featureConfig;
        Feature oreFeature;
        if (feature.field_222738_b instanceof DecoratedFeatureConfig && ((oreFeature = ((DecoratedFeatureConfig)feature.field_222738_b).field_214689_a.field_222737_a) == Feature.field_202290_aj || oreFeature == Feature.field_202294_an) && (featureConfig = ((DecoratedFeatureConfig)feature.field_222738_b).field_214689_a.field_222738_b) instanceof OreFeatureConfig) {
            OreFeatureConfig oreConfig = (OreFeatureConfig)featureConfig;
            return disableAll || disabledBlockStates.contains(oreConfig.field_202444_d);
        }
        return false;
    }
}

