/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.oreveins.world;

import com.alcatrazescapee.oreveins.Config;
import com.alcatrazescapee.oreveins.world.vein.Indicator;
import com.alcatrazescapee.oreveins.world.vein.Vein;
import com.alcatrazescapee.oreveins.world.vein.VeinManager;
import com.alcatrazescapee.oreveins.world.vein.VeinType;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

@ParametersAreNonnullByDefault
public class VeinsFeature
extends Feature<NoFeatureConfig> {
    private static final Random RANDOM = new Random();
    private static int CHUNK_RADIUS = 0;

    public static void resetChunkRadius() {
        CHUNK_RADIUS = 1 + VeinManager.INSTANCE.getVeins().stream().mapToInt(VeinType::getChunkRadius).max().orElse(0) + (Integer)Config.COMMON.extraChunkRange.get();
    }

    @Nonnull
    public static List<Vein<?>> getNearbyVeins(int chunkX, int chunkZ, long worldSeed, int radius) {
        ArrayList veins = new ArrayList();
        for (int x = chunkX - radius; x <= chunkX + radius; ++x) {
            for (int z = chunkZ - radius; z <= chunkZ + radius; ++z) {
                VeinsFeature.getVeinsAtChunk(veins, x, z, worldSeed);
            }
        }
        return veins;
    }

    private static void getVeinsAtChunk(List<Vein<?>> veins, int chunkX, int chunkZ, long worldSeed) {
        RANDOM.setSeed(worldSeed + (long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        for (VeinType<?> type : VeinManager.INSTANCE.getVeins()) {
            for (int i = 0; i < type.getCount(); ++i) {
                if (RANDOM.nextInt(type.getRarity()) != 0) continue;
                Object vein = type.createVein(chunkX, chunkZ, RANDOM);
                veins.add((Vein<?>)vein);
            }
        }
    }

    public VeinsFeature() {
        super(NoFeatureConfig::func_214639_a);
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        List<Vein<?>> veins = VeinsFeature.getNearbyVeins(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4, worldIn.func_72905_C(), CHUNK_RADIUS);
        if (veins.isEmpty()) {
            return false;
        }
        for (Vein<?> vein : veins) {
            if (!((VeinType)vein.getType()).matchesDimension(worldIn.func_201675_m())) continue;
            this.generate(worldIn, rand, pos.func_177958_n(), pos.func_177952_p(), vein);
        }
        return true;
    }

    private void generate(IWorld world, Random random, int xOff, int zOff, Vein<?> vein) {
        for (int x = xOff; x < 16 + xOff; ++x) {
            for (int z = zOff; z < 16 + zOff; ++z) {
                Biome biomeAt = world.func_180494_b(new BlockPos(x, 0, z));
                if (!((VeinType)vein.getType()).matchesBiome(biomeAt) || !vein.inRange(x, z)) continue;
                Indicator veinIndicator = ((VeinType)vein.getType()).getIndicator(random);
                boolean canGenerateIndicator = false;
                for (int y = ((VeinType)vein.getType()).getMinY(); y <= ((VeinType)vein.getType()).getMaxY(); ++y) {
                    BlockPos posAt = new BlockPos(x, y, z);
                    if (!((double)random.nextFloat() < vein.getChanceToGenerate(posAt)) || !((VeinType)vein.getType()).canGenerateAt((IBlockReader)world, posAt)) continue;
                    BlockState oreState = ((VeinType)vein.getType()).getStateToGenerate(random);
                    this.func_202278_a((IWorldWriter)world, posAt, oreState);
                    if (veinIndicator == null || canGenerateIndicator) continue;
                    int depth = world.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, x, z) - y;
                    if (depth < 0) {
                        depth = -depth;
                    }
                    canGenerateIndicator = depth < veinIndicator.getMaxDepth();
                }
                if (veinIndicator == null || !canGenerateIndicator || random.nextInt(veinIndicator.getRarity()) != 0) continue;
                BlockPos posAt = world.func_205770_a(Heightmap.Type.WORLD_SURFACE_WG, new BlockPos(x, 0, z));
                BlockState indicatorState = veinIndicator.getStateToGenerate(random);
                BlockState stateAt = world.func_180495_p(posAt);
                if (!indicatorState.func_196955_c((IWorldReader)world, posAt) || !veinIndicator.shouldIgnoreLiquids() && stateAt.func_185904_a().func_76224_d() || !veinIndicator.validUnderState(world.func_180495_p(posAt.func_177977_b()))) continue;
                this.func_202278_a((IWorldWriter)world, posAt, indicatorState);
            }
        }
    }
}

