/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.oreveins.world.rule;

import com.alcatrazescapee.oreveins.util.json.PredicateDeserializer;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.function.Predicate;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

@FunctionalInterface
public interface BiomeRule
extends Predicate<Biome> {
    public static final BiomeRule DEFAULT = biome -> true;

    public static class Deserializer
    extends PredicateDeserializer<Biome, BiomeRule> {
        public static final Deserializer INSTANCE = new Deserializer();

        private Deserializer() {
            super(BiomeRule.class, "biomes");
        }

        @Override
        protected BiomeRule createSingleRule(JsonObject json, String typeName) {
            if ("tag".equals(typeName)) {
                BiomeDictionary.Type type = BiomeDictionary.Type.getType((String)typeName, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
                return biome -> BiomeDictionary.getTypes((Biome)biome).contains(type);
            }
            if ("biome".equals(typeName)) {
                return this.createSingleRule(json.get("biomes").getAsString());
            }
            throw new JsonParseException("Type must be logical (and, or, not), or (biome, tag)");
        }

        @Override
        protected BiomeRule createSingleRule(String name) {
            ResourceLocation biomeName = new ResourceLocation(name);
            return biome -> biomeName.equals((Object)biome.getRegistryName());
        }

        @Override
        protected BiomeRule createPredicate(Predicate<Biome> predicate) {
            return predicate::test;
        }
    }
}

