/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.oreveins.world.rule;

import com.alcatrazescapee.oreveins.world.rule.TouchingRule;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

@ParametersAreNonnullByDefault
public interface IRule
extends BiPredicate<IBlockReader, BlockPos> {
    @Override
    public boolean test(IBlockReader var1, BlockPos var2);

    public static interface Factory<T extends IRule> {
        @Nonnull
        public T parse(JsonObject var1, JsonDeserializationContext var2);
    }

    public static enum Deserializer implements JsonDeserializer<IRule>
    {
        INSTANCE;

        private final Map<String, Factory<? extends IRule>> types = new HashMap<String, Factory<? extends IRule>>();

        private Deserializer() {
            this.types.put("touching", new TouchingRule.Factory());
        }

        public IRule deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            String conditionType = obj.get("type").getAsString();
            if (this.types.containsKey(conditionType)) {
                return this.types.get(conditionType).parse(obj, context);
            }
            throw new JsonParseException("Unknown rule type: " + conditionType);
        }
    }
}

