/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.oreveins.world.rule;

import com.alcatrazescapee.oreveins.world.rule.IRule;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

@ParametersAreNonnullByDefault
public class TouchingRule
implements IRule {
    private Predicate<BlockState> blockMatcher;
    private int minMatches;
    private int maxMatches;

    private TouchingRule(Predicate<BlockState> blockMatcher, int minMatches, int maxMatches) {
        this.blockMatcher = blockMatcher;
        this.minMatches = minMatches;
        this.maxMatches = maxMatches;
    }

    @Override
    public boolean test(IBlockReader world, BlockPos pos) {
        int matchCount = 0;
        for (Direction face : Direction.values()) {
            if (this.blockMatcher.test(world.func_180495_p(pos.func_177972_a(face)))) {
                ++matchCount;
            }
            if (this.minMatches > matchCount || matchCount > this.maxMatches) continue;
            return true;
        }
        return false;
    }

    public static final class Factory
    implements IRule.Factory<TouchingRule> {
        @Override
        @Nonnull
        public TouchingRule parse(JsonObject json, JsonDeserializationContext context) {
            BlockState stateToMatch = (BlockState)context.deserialize(json.get("block"), BlockState.class);
            Predicate<BlockState> blockMatcher = state -> state == stateToMatch;
            int min = JSONUtils.func_151208_a((JsonObject)json, (String)"min", (int)1);
            int max = JSONUtils.func_151208_a((JsonObject)json, (String)"max", (int)8);
            return new TouchingRule(blockMatcher, min, max);
        }
    }
}

