/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.oreveins.world.vein;

import com.alcatrazescapee.oreveins.world.vein.Vein;
import com.alcatrazescapee.oreveins.world.vein.VeinType;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.math.BlockPos;

@ParametersAreNonnullByDefault
public class ClusterVeinType
extends VeinType<VeinCluster> {
    private final int clusters;

    public ClusterVeinType(JsonObject obj, JsonDeserializationContext context) throws JsonParseException {
        super(obj, context);
        this.clusters = JSONUtils.func_151208_a((JsonObject)obj, (String)"clusters", (int)3);
        if (this.clusters <= 0) {
            throw new JsonParseException("Clusters must be > 0");
        }
    }

    @Override
    public boolean inRange(VeinCluster vein, int xOffset, int zOffset) {
        return (float)(xOffset * xOffset + zOffset * zOffset) < (float)(this.horizontalSize * this.horizontalSize) * vein.getSize();
    }

    @Override
    public float getChanceToGenerate(VeinCluster vein, BlockPos pos) {
        float shortestRadius = -1.0f;
        for (Cluster c : vein.spawnPoints) {
            double dx = Math.pow(c.pos.func_177958_n() - pos.func_177958_n(), 2.0);
            double dy = Math.pow(c.pos.func_177956_o() - pos.func_177956_o(), 2.0);
            double dz = Math.pow(c.pos.func_177952_p() - pos.func_177952_p(), 2.0);
            float radius = (float)((dx + dz) / (double)((float)(this.horizontalSize * this.horizontalSize) * vein.getSize() * c.size) + dy / (double)((float)(this.verticalSize * this.verticalSize) * vein.getSize() * c.size));
            if (shortestRadius != -1.0f && !(radius < shortestRadius)) continue;
            shortestRadius = radius;
        }
        return 0.005f * this.density * (1.0f - shortestRadius);
    }

    @Override
    @Nonnull
    public VeinCluster createVein(int chunkX, int chunkZ, Random rand) {
        return new VeinCluster(this, this.defaultStartPos(chunkX, chunkZ, rand), rand);
    }

    private static class Cluster {
        private final BlockPos pos;
        private final float size;

        private Cluster(BlockPos pos, float size) {
            this.pos = pos;
            this.size = size;
        }
    }

    static class VeinCluster
    extends Vein<ClusterVeinType> {
        private final Cluster[] spawnPoints;

        private VeinCluster(ClusterVeinType type, BlockPos pos, Random rand) {
            super(type, pos, rand);
            int clusters = (int)((float)type.clusters * (0.5f + rand.nextFloat()));
            this.spawnPoints = new Cluster[clusters];
            this.spawnPoints[0] = new Cluster(pos, 0.6f + 0.2f * rand.nextFloat());
            for (int i = 1; i < clusters; ++i) {
                BlockPos clusterPos = pos.func_177963_a((double)((float)type.horizontalSize * (0.3f - 0.6f * rand.nextFloat())), (double)((float)type.verticalSize * (0.3f - 0.6f * rand.nextFloat())), (double)((float)type.horizontalSize * (0.3f - 0.6f * rand.nextFloat())));
                this.spawnPoints[i] = new Cluster(clusterPos, 0.2f + 0.5f * rand.nextFloat());
            }
        }

        @Override
        public boolean inRange(int x, int z) {
            return ((ClusterVeinType)this.getType()).inRange(this, this.getPos().func_177958_n() - x, this.getPos().func_177952_p() - z);
        }

        @Override
        public double getChanceToGenerate(@Nonnull BlockPos pos) {
            return ((ClusterVeinType)this.getType()).getChanceToGenerate(this, pos);
        }
    }
}

