/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.oreveins.world.vein;

import com.alcatrazescapee.oreveins.util.IWeightedList;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.util.JSONUtils;

public class Indicator {
    private final int maxDepth;
    private final int rarity;
    private final boolean ignoreLiquids;
    private final IWeightedList<BlockState> states;
    private final List<BlockState> underStates;

    private Indicator(int maxDepth, int rarity, boolean ignoreLiquids, IWeightedList<BlockState> states, List<BlockState> underStates) {
        this.maxDepth = maxDepth;
        this.rarity = rarity;
        this.ignoreLiquids = ignoreLiquids;
        this.states = states;
        this.underStates = underStates;
    }

    @Nonnull
    public BlockState getStateToGenerate(Random random) {
        return this.states.get(random);
    }

    public boolean validUnderState(BlockState state) {
        return this.underStates.isEmpty() || this.underStates.contains(state);
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public int getRarity() {
        return this.rarity;
    }

    public boolean shouldIgnoreLiquids() {
        return this.ignoreLiquids;
    }

    public static enum Deserializer implements JsonDeserializer<Indicator>
    {
        INSTANCE;


        public Indicator deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (!json.isJsonObject()) {
                throw new JsonParseException("Indicator must be a JSON Object");
            }
            JsonObject obj = json.getAsJsonObject();
            int maxDepth = JSONUtils.func_151208_a((JsonObject)obj, (String)"max_depth", (int)32);
            if (maxDepth <= 0) {
                throw new JsonParseException("Max depth must be > 0");
            }
            int rarity = JSONUtils.func_151208_a((JsonObject)obj, (String)"rarity", (int)10);
            if (rarity <= 0) {
                throw new JsonParseException("Rarity must be > 0");
            }
            boolean ignoreLiquids = JSONUtils.func_151209_a((JsonObject)obj, (String)"ignore_liquids", (boolean)false);
            IWeightedList states = (IWeightedList)context.deserialize(obj.get("blocks"), new TypeToken<IWeightedList<BlockState>>(){}.getType());
            if (states.isEmpty()) {
                throw new JsonParseException("Block states cannot be empty!");
            }
            List underStates = obj.has("blocks_under") ? (List)context.deserialize(obj.get("blocks_under"), new TypeToken<List<BlockState>>(){}.getType()) : Collections.emptyList();
            return new Indicator(maxDepth, rarity, ignoreLiquids, states, underStates);
        }
    }
}

