/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.oreveins.world.vein;

import com.alcatrazescapee.oreveins.world.vein.VeinManager;
import com.alcatrazescapee.oreveins.world.vein.VeinType;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;

public class Vein<T extends VeinType<?>> {
    protected final T type;
    protected final BlockPos pos;
    protected final float size;

    public Vein(T type, BlockPos pos, float size) {
        this.pos = pos;
        this.type = type;
        this.size = size;
    }

    public Vein(T type, BlockPos pos, Random random) {
        this(type, pos, 0.7f + random.nextFloat() * 0.3f);
    }

    @Nonnull
    public BlockPos getPos() {
        return this.pos;
    }

    public T getType() {
        return this.type;
    }

    public float getSize() {
        return this.size;
    }

    public String toString() {
        return String.format("Vein: %s, Pos: %s", VeinManager.INSTANCE.getName((VeinType<?>)this.type), this.pos);
    }

    public boolean inRange(int x, int z) {
        return this.getTypeRaw().inRange(this, this.pos.func_177958_n() - x, this.pos.func_177952_p() - z);
    }

    public double getChanceToGenerate(BlockPos pos) {
        return this.getTypeRaw().getChanceToGenerate(this, pos);
    }

    private <V extends Vein<T>> VeinType<V> getTypeRaw() {
        return this.type;
    }
}

