/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.oreveins.world.vein;

import com.alcatrazescapee.oreveins.command.ClearWorldCommand;
import com.alcatrazescapee.oreveins.util.IWeightedList;
import com.alcatrazescapee.oreveins.util.json.BlockStateDeserializer;
import com.alcatrazescapee.oreveins.util.json.LenientListDeserializer;
import com.alcatrazescapee.oreveins.util.json.VeinTypeDeserializer;
import com.alcatrazescapee.oreveins.util.json.WeightedListDeserializer;
import com.alcatrazescapee.oreveins.world.VeinsFeature;
import com.alcatrazescapee.oreveins.world.rule.BiomeRule;
import com.alcatrazescapee.oreveins.world.rule.DimensionRule;
import com.alcatrazescapee.oreveins.world.rule.IRule;
import com.alcatrazescapee.oreveins.world.vein.Indicator;
import com.alcatrazescapee.oreveins.world.vein.VeinType;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
public class VeinManager
extends JsonReloadListener {
    public static final VeinManager INSTANCE;
    private static final Logger LOGGER;
    private static final Gson GSON;
    private final BiMap<ResourceLocation, VeinType<?>> veins = HashBiMap.create();

    private VeinManager() {
        super(GSON, "oreveins");
    }

    @Nonnull
    public Collection<VeinType<?>> getVeins() {
        return this.veins.values();
    }

    @Nonnull
    public Set<ResourceLocation> getKeys() {
        return this.veins.keySet();
    }

    @Nullable
    public VeinType<?> getVein(ResourceLocation key) {
        return (VeinType)this.veins.get((Object)key);
    }

    @Nonnull
    public ResourceLocation getName(VeinType<?> key) {
        return (ResourceLocation)this.veins.inverse().get(key);
    }

    protected void apply(Map<ResourceLocation, JsonObject> resources, IResourceManager manager, IProfiler profiler) {
        for (Map.Entry<ResourceLocation, JsonObject> entry : resources.entrySet()) {
            ResourceLocation name = entry.getKey();
            JsonObject json = entry.getValue();
            try {
                if (CraftingHelper.processConditions((JsonObject)json, (String)"conditions")) {
                    this.veins.put((Object)name, GSON.fromJson((JsonElement)json, VeinType.class));
                    continue;
                }
                LOGGER.info("Skipping loading vein '{}' as it's conditions were not met", (Object)name);
            }
            catch (JsonParseException | IllegalArgumentException e) {
                LOGGER.warn("Vein '{}' failed to parse. This is most likely caused by incorrectly specified JSON.", (Object)entry.getKey());
                LOGGER.warn("Error: ", e);
            }
        }
        LOGGER.info("Registered {} Veins Successfully.", (Object)this.veins.size());
        ClearWorldCommand.resetVeinStates();
        VeinsFeature.resetChunkRadius();
    }

    static {
        LOGGER = LogManager.getLogger();
        GSON = new GsonBuilder().registerTypeAdapter(new TypeToken<IWeightedList<BlockState>>(){}.getType(), new WeightedListDeserializer<BlockState>(BlockState.class)).registerTypeAdapter(new TypeToken<IWeightedList<Indicator>>(){}.getType(), new WeightedListDeserializer<Indicator>(Indicator.class)).registerTypeAdapter(new TypeToken<List<BlockState>>(){}.getType(), new LenientListDeserializer<BlockState, List>(BlockState.class, Collections::singletonList, ArrayList::new)).registerTypeAdapter(BlockState.class, (Object)BlockStateDeserializer.INSTANCE).registerTypeAdapter(IRule.class, (Object)IRule.Deserializer.INSTANCE).registerTypeAdapter(Indicator.class, (Object)Indicator.Deserializer.INSTANCE).registerTypeAdapter(BiomeRule.class, (Object)BiomeRule.Deserializer.INSTANCE).registerTypeAdapter(DimensionRule.class, (Object)DimensionRule.Deserializer.INSTANCE).registerTypeAdapter(VeinType.class, (Object)VeinTypeDeserializer.INSTANCE).disableHtmlEscaping().create();
        INSTANCE = new VeinManager();
    }
}

