/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.oreveins.world.vein;

import com.alcatrazescapee.oreveins.Config;
import com.alcatrazescapee.oreveins.util.IWeightedList;
import com.alcatrazescapee.oreveins.world.rule.BiomeRule;
import com.alcatrazescapee.oreveins.world.rule.DimensionRule;
import com.alcatrazescapee.oreveins.world.rule.IRule;
import com.alcatrazescapee.oreveins.world.vein.Indicator;
import com.alcatrazescapee.oreveins.world.vein.Vein;
import com.alcatrazescapee.oreveins.world.vein.VeinManager;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.dimension.Dimension;

@ParametersAreNonnullByDefault
public abstract class VeinType<V extends Vein<?>> {
    protected final int verticalSize;
    protected final int horizontalSize;
    protected final float density;
    private final int count;
    private final int rarity;
    private final int minY;
    private final int maxY;
    private final List<BlockState> stoneStates;
    private final IWeightedList<BlockState> oreStates;
    private final BiomeRule biomes;
    private final DimensionRule dimensions;
    private final List<IRule> rules;
    private final IWeightedList<Indicator> indicator;

    protected VeinType(JsonObject json, JsonDeserializationContext context) throws JsonParseException {
        this.count = JSONUtils.func_151208_a((JsonObject)json, (String)"count", (int)1);
        if (this.count <= 0) {
            throw new JsonParseException("Count must be > 0.");
        }
        this.rarity = JSONUtils.func_151208_a((JsonObject)json, (String)"rarity", (int)10);
        if (this.rarity <= 0) {
            throw new JsonParseException("Count must be > 0.");
        }
        this.minY = JSONUtils.func_151208_a((JsonObject)json, (String)"min_y", (int)16);
        this.maxY = JSONUtils.func_151208_a((JsonObject)json, (String)"max_y", (int)64);
        if (this.minY < 0 || this.maxY > 256 || this.minY > this.maxY) {
            throw new JsonParseException("Min Y and Max Y must be within [0, 256], and Min Y must be <= Max Y.");
        }
        this.verticalSize = JSONUtils.func_151208_a((JsonObject)json, (String)"vertical_size", (int)8);
        if (this.verticalSize <= 0) {
            throw new JsonParseException("Vertical Size must be > 0.");
        }
        this.horizontalSize = JSONUtils.func_151208_a((JsonObject)json, (String)"horizontal_size", (int)15);
        if (this.horizontalSize <= 0) {
            throw new JsonParseException("Horizontal Size must be > 0.");
        }
        this.density = JSONUtils.func_151208_a((JsonObject)json, (String)"density", (int)20);
        if (this.density <= 0.0f) {
            throw new JsonParseException("Density must be > 0.");
        }
        this.stoneStates = (List)context.deserialize(json.get("stone"), new TypeToken<List<BlockState>>(){}.getType());
        if (this.stoneStates.isEmpty()) {
            throw new JsonParseException("Stone States cannot be empty.");
        }
        this.oreStates = (IWeightedList)context.deserialize(json.get("ore"), new TypeToken<IWeightedList<BlockState>>(){}.getType());
        if (this.oreStates.isEmpty()) {
            throw new JsonParseException("Ore States cannot be empty.");
        }
        this.biomes = json.has("biomes") ? (BiomeRule)context.deserialize(json.get("biomes"), BiomeRule.class) : BiomeRule.DEFAULT;
        this.dimensions = json.has("dimensions") ? (DimensionRule)context.deserialize(json.get("dimensions"), DimensionRule.class) : DimensionRule.DEFAULT;
        this.rules = json.has("rules") ? (List)context.deserialize(json.get("rules"), new TypeToken<List<IRule>>(){}.getType()) : Collections.emptyList();
        this.indicator = json.has("indicator") ? (IWeightedList)context.deserialize(json.get("indicator"), new TypeToken<IWeightedList<Indicator>>(){}.getType()) : IWeightedList.empty();
    }

    @Nonnull
    public BlockState getStateToGenerate(Random rand) {
        return this.oreStates.get(rand);
    }

    @Nonnull
    public Collection<BlockState> getOreStates() {
        return this.oreStates.values();
    }

    @Nullable
    public Indicator getIndicator(Random random) {
        return this.indicator != null ? this.indicator.get(random) : null;
    }

    public boolean canGenerateAt(IBlockReader world, BlockPos pos) {
        BlockState stoneState = world.func_180495_p(pos);
        if (this.stoneStates.contains(stoneState)) {
            if (this.rules != null) {
                for (IRule rule : this.rules) {
                    if (rule.test(world, pos)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public boolean inRange(V vein, int xOffset, int zOffset) {
        return (float)(xOffset * xOffset + zOffset * zOffset) < (float)(this.horizontalSize * this.horizontalSize) * ((Vein)vein).getSize();
    }

    public boolean matchesDimension(Dimension dimension) {
        return this.dimensions.test(dimension);
    }

    public boolean matchesBiome(Biome biome) {
        return this.biomes.test(biome);
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int getCount() {
        return this.count;
    }

    public int getRarity() {
        return this.rarity;
    }

    public int getChunkRadius() {
        return 1 + (this.horizontalSize >> 4);
    }

    public String toString() {
        return String.format("[%s: Count: %d, Rarity: %d, Y: %d - %d, Size: %d / %d, Density: %2.2f, Ores: %s, Stones: %s]", VeinManager.INSTANCE.getName(this), this.count, this.rarity, this.minY, this.maxY, this.horizontalSize, this.verticalSize, Float.valueOf(this.density), this.oreStates, this.stoneStates);
    }

    public abstract float getChanceToGenerate(V var1, BlockPos var2);

    @Nonnull
    public V createVein(int chunkX, int chunkZ, Random rand) {
        return (V)new Vein<VeinType>(this, this.defaultStartPos(chunkX, chunkZ, rand), rand);
    }

    protected final BlockPos defaultStartPos(int chunkX, int chunkZ, Random rand) {
        int spawnRange = this.maxY - this.minY;
        int minRange = this.minY;
        if (((Boolean)Config.COMMON.avoidVeinCutoffs.get()).booleanValue()) {
            if (this.verticalSize * 2 < spawnRange) {
                spawnRange -= this.verticalSize * 2;
                minRange += this.verticalSize;
            } else {
                minRange = this.minY + (this.maxY - this.minY) / 2;
                spawnRange = 1;
            }
        }
        return new BlockPos(chunkX * 16 + rand.nextInt(16), minRange + rand.nextInt(spawnRange), chunkZ * 16 + rand.nextInt(16));
    }
}

