/*
 * Decompiled with CFR 0.152.
 */
package puddles;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;

public class PuddlesConfig {
    private static final ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
    public static ForgeConfigSpec COMMON_CONFIG;
    public static ForgeConfigSpec.IntValue puddleRate;
    public static ForgeConfigSpec.IntValue puddleEvaporationRate;

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.setConfig((CommentedConfig)configData);
    }

    static {
        COMMON_BUILDER.comment("Puddles Settings").push("Puddles");
        COMMON_BUILDER.comment("Puddle Rate").comment("Default: 5");
        puddleRate = COMMON_BUILDER.comment("How fast puddles generate - (0-5 is reasonable)").defineInRange("puddleRate", 5, 0, 1200);
        COMMON_BUILDER.comment("Puddle Evaporation Rate").comment("Default: 30");
        puddleEvaporationRate = COMMON_BUILDER.comment("How fast puddles evaporate").defineInRange("puddleEvaporationRate", 30, 0, 100);
        COMMON_BUILDER.pop();
        COMMON_CONFIG = COMMON_BUILDER.build();
    }
}

