/*
 * Decompiled with CFR 0.152.
 */
package puddles;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ILightReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeColors;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import puddles.PuddleBlock;
import puddles.PuddlesConfig;

@Mod(value="puddles")
@Mod.EventBusSubscriber(modid="puddles", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Puddles {
    public static final String MOD_ID = "puddles";
    public static final Logger LOGGER = LogManager.getLogger((String)"puddles");
    public static Block puddle;

    public Puddles() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, PuddlesConfig.COMMON_CONFIG);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        PuddlesConfig.loadConfig(PuddlesConfig.COMMON_CONFIG, FMLPaths.CONFIGDIR.get().resolve("puddles-common.toml"));
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        puddle = (Block)new PuddleBlock().setRegistryName(new ResourceLocation(MOD_ID, "puddle"));
        event.getRegistry().register((IForgeRegistryEntry)puddle);
        Item.Properties prop = new Item.Properties().func_200916_a(ItemGroup.field_78026_f);
        BlockItem item = new BlockItem(puddle, prop);
        item.setRegistryName(new ResourceLocation(MOD_ID, "puddle"));
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
        LOGGER.info("Loaded puddles.");
    }

    private void clientSetup(FMLClientSetupEvent event) {
        RenderTypeLookup.setRenderLayer((Block)puddle, (RenderType)RenderType.func_228645_f_());
        BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
        ItemColors itemColors = Minecraft.func_71410_x().getItemColors();
        blockColors.func_186722_a((state, world, pos, tintIndex) -> world != null && pos != null ? BiomeColors.func_228363_c_((ILightReader)world, (BlockPos)pos) : 4159204, new Block[]{puddle});
        itemColors.func_199877_a((itemstack, tintIndex) -> 4159204, new IItemProvider[]{puddle});
    }

    @SubscribeEvent
    public void placePuddles(TickEvent.ServerTickEvent event) {
        try {
            ServerWorld world = ServerLifecycleHooks.getCurrentServer().func_71218_a(DimensionType.field_223227_a_);
            if (world.func_72896_J() && world.func_201675_m().func_186058_p() == DimensionType.field_223227_a_ && world.func_82737_E() % 20L == 0L) {
                Class<?> clazz = world.func_72863_F().field_217237_a.getClass();
                Method getLoadedChunks = clazz.getDeclaredMethod("getLoadedChunksIterable", new Class[0]);
                getLoadedChunks.setAccessible(true);
                Iterable iterator = (Iterable)getLoadedChunks.invoke((Object)world.func_72863_F().field_217237_a, new Object[0]);
                iterator.forEach(chunk -> {
                    int y;
                    int z;
                    Random random;
                    int x;
                    ChunkPos chunkPos;
                    BlockPos pos;
                    BlockPos puddlePos;
                    Optional optional = chunk.func_219297_b().getNow(ChunkHolder.field_219308_c).left();
                    if (optional.isPresent() && this.canSpawnPuddle((World)world, puddlePos = (pos = (chunkPos = chunk.func_219277_h()).func_180331_a(x = (random = world.field_73012_v).nextInt(16), 0, z = random.nextInt(16))).func_177982_a(0, (y = world.func_201676_a(Heightmap.Type.MOTION_BLOCKING, pos.func_177958_n(), pos.func_177952_p())) - 1, 0)) && random.nextFloat() * 1200.0f < (float)((Integer)PuddlesConfig.puddleRate.get()).intValue()) {
                        world.func_180501_a(puddlePos.func_177984_a(), puddle.func_176223_P(), 2);
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean canSpawnPuddle(World world, BlockPos pos) {
        if (!world.func_180495_p(pos).func_200132_m()) {
            return false;
        }
        if (!world.func_175623_d(pos.func_177984_a())) {
            return false;
        }
        if (!world.func_72896_J()) {
            return false;
        }
        Biome biome = world.func_226691_t_(pos);
        if (((List)PuddlesConfig.biomeBlacklist.get()).contains(biome.getRegistryName().toString())) {
            return false;
        }
        if (biome.func_201851_b() == Biome.RainType.NONE) {
            return false;
        }
        if (!biome.func_201850_b((IWorldReader)world, pos)) {
            for (int y = pos.func_177956_o() + 1; y < world.func_72940_L(); ++y) {
                BlockPos up = new BlockPos(pos.func_177958_n(), y, pos.func_177952_p());
                if (world.func_175623_d(up)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void puddleInteract(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack = event.getItemStack();
        World world = event.getWorld();
        BlockPos pos = event.getPos().func_177984_a();
        PlayerEntity player = event.getPlayer();
        if (world.func_180495_p(pos).func_177230_c() == puddle && stack.func_77973_b() == Items.field_151069_bo && event.getFace() == Direction.UP) {
            if (!world.field_72995_K) {
                stack.func_190918_g(1);
                if (!player.field_71071_by.func_70441_a(PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185230_b))) {
                    player.func_71019_a(PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185230_b), false);
                }
                world.func_217377_a(pos, false);
            } else {
                world.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187615_H, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public void makeBigSplash(LivingFallEvent event) {
        Entity entity = event.getEntity();
        BlockPos pos = entity.func_180425_c();
        World world = entity.func_130014_f_();
        if (!world.field_72995_K && world.func_180495_p(pos).func_177230_c() == puddle) {
            float distance = event.getDistance();
            if (distance < 3.0f) {
                ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_218422_X, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 15, 0.0, 0.0, 0.0, 0.13);
            } else {
                float f = MathHelper.func_76123_f((float)(distance - 3.0f));
                double d0 = Math.min((double)(0.2f + f / 15.0f), 2.5);
                int i = (int)(200.0 * d0);
                for (int a = 0; a < 20; ++a) {
                    double x = 0.8 * (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble());
                    double z = 0.8 * (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble());
                    ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_218422_X, entity.func_226277_ct_() + x, entity.func_226278_cu_(), entity.func_226281_cx_() + z, i / 2, 0.0, 0.0, 0.0, 0.25);
                }
                world.func_184133_a(null, pos, SoundEvents.field_187806_ee, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            }
        }
    }
}

