/*
 * Decompiled with CFR 0.152.
 */
package puddles;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class PuddlesConfig {
    private static final ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
    public static ForgeConfigSpec COMMON_CONFIG;
    public static ForgeConfigSpec.IntValue puddleRate;
    public static ForgeConfigSpec.IntValue puddleEvaporationRate;
    public static ForgeConfigSpec.ConfigValue<List<String>> biomeBlacklist;

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.setConfig((CommentedConfig)configData);
    }

    static {
        COMMON_BUILDER.comment("Puddles Settings").push("Puddles");
        puddleRate = COMMON_BUILDER.comment("How fast puddles generate - (0-5 is reasonable) Default: 5").defineInRange("puddleRate", 5, 0, 1200);
        puddleEvaporationRate = COMMON_BUILDER.comment("How fast puddles evaporate. Default: 40").defineInRange("puddleEvaporationRate", 50, 0, 100);
        biomeBlacklist = COMMON_BUILDER.comment("Biome blacklist").define("biomeBlacklist", new ArrayList());
        COMMON_BUILDER.pop();
        COMMON_CONFIG = COMMON_BUILDER.build();
    }
}

