/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.oreveins;

import com.alcatrazescapee.oreveins.OreVeinsConfig;
import com.alcatrazescapee.oreveins.cmd.CommandClearWorld;
import com.alcatrazescapee.oreveins.cmd.CommandFindVeins;
import com.alcatrazescapee.oreveins.cmd.CommandVeinInfo;
import com.alcatrazescapee.oreveins.vein.VeinRegistry;
import com.alcatrazescapee.oreveins.world.AtChunk;
import com.alcatrazescapee.oreveins.world.FeatureVeins;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.command.CommandSource;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.CompositeFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.placement.BasePlacement;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="oreveins")
public class OreVeins {
    public static final String MOD_ID = "oreveins";
    private static final Logger LOGGER = LogManager.getLogger();

    public OreVeins() {
        LOGGER.info("Init oreveins");
        OreVeinsConfig.INSTANCE.setup();
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        MinecraftForge.EVENT_BUS.addListener(this::onServerStarting);
    }

    @SubscribeEvent
    public void onLoadConfig(ModConfig.Loading event) {
        if (event.getConfig().getType() == ModConfig.Type.SERVER) {
            OreVeinsConfig.INSTANCE.load();
            if (OreVeinsConfig.INSTANCE.noOres) {
                ForgeRegistries.BIOMES.forEach(biome -> biome.func_203607_a(GenerationStage.Decoration.UNDERGROUND_ORES).removeIf(x -> x.func_202349_a() == Feature.field_202290_aj));
            }
        }
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent event) {
        VeinRegistry.preInit();
        ForgeRegistries.BIOMES.forEach(biome -> {
            CompositeFeature feature = Biome.func_201864_a((Feature)new FeatureVeins(), (IFeatureConfig)new NoFeatureConfig(), (BasePlacement)new AtChunk(), (IPlacementConfig)IPlacementConfig.field_202468_e);
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, feature);
        });
        CommandClearWorld.resetVeinStates();
        FeatureVeins.resetChunkRadius();
    }

    private void onServerStarting(FMLServerStartingEvent event) {
        if (OreVeinsConfig.INSTANCE.debugCommands) {
            LOGGER.info("Registering Debug Commands");
            CommandDispatcher dispatcher = event.getCommandDispatcher();
            CommandClearWorld.register((CommandDispatcher<CommandSource>)dispatcher);
            CommandFindVeins.register((CommandDispatcher<CommandSource>)dispatcher);
            CommandVeinInfo.register((CommandDispatcher<CommandSource>)dispatcher);
        }
    }
}

