/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.oreveins;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public enum OreVeinsConfig {
    INSTANCE;

    private static final ServerConfig SERVER;
    private static final ForgeConfigSpec SERVER_SPEC;
    public boolean noOres;
    public boolean debugCommands;
    public int extraChunkRange;

    public void setup() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, SERVER_SPEC);
    }

    public void load() {
        this.noOres = (Boolean)SERVER.noOres.get();
        this.debugCommands = (Boolean)SERVER.debugCommands.get();
        this.extraChunkRange = (Integer)SERVER.extraChunkRange.get();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_SPEC = (ForgeConfigSpec)specPair.getRight();
        SERVER = (ServerConfig)specPair.getLeft();
    }

    public static class ServerConfig {
        private ForgeConfigSpec.BooleanValue noOres;
        private ForgeConfigSpec.BooleanValue debugCommands;
        private ForgeConfigSpec.IntValue extraChunkRange;

        ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.push("general");
            this.noOres = builder.comment("Stop all vanilla ore gen calls?").define("no_ores", true);
            this.debugCommands = builder.comment("Enable debug commands such as /veininfo, /clearworld, /findveins").define("debug_commands", true);
            this.extraChunkRange = builder.comment(new String[]{"Extra chunk search range when generating veins", "Use if your veins are getting cut off at chunk boundaries"}).defineInRange("extra_chunk_range", 0, 0, 20);
            builder.pop();
        }
    }
}

