/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.oreveins.api;

import com.alcatrazescapee.oreveins.api.IVein;
import com.alcatrazescapee.oreveins.api.IVeinType;
import com.alcatrazescapee.oreveins.vein.VeinRegistry;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;

public abstract class AbstractVein<T extends IVeinType<?>>
implements IVein<T> {
    protected final T type;
    protected final BlockPos pos;
    protected final float size;

    public AbstractVein(T type, BlockPos pos, float size) {
        this.pos = pos;
        this.type = type;
        this.size = size;
    }

    public AbstractVein(T type, BlockPos pos, Random random) {
        this(type, pos, 0.7f + random.nextFloat() * 0.3f);
    }

    @Override
    @Nonnull
    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public T getType() {
        return this.type;
    }

    public float getSize() {
        return this.size;
    }

    public String toString() {
        return String.format("Vein: %s, Pos: %s", VeinRegistry.getName(this.type), this.pos);
    }
}

