/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.oreveins.api;

import com.alcatrazescapee.oreveins.api.AbstractVein;
import com.alcatrazescapee.oreveins.api.IVeinType;
import com.alcatrazescapee.oreveins.util.IWeightedList;
import com.alcatrazescapee.oreveins.vein.Indicator;
import com.alcatrazescapee.oreveins.vein.VeinRegistry;
import com.google.gson.annotations.SerializedName;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.dimension.Dimension;
import net.minecraftforge.common.BiomeDictionary;

@ParametersAreNonnullByDefault
public abstract class AbstractVeinType<V extends AbstractVein<?>>
implements IVeinType<V> {
    protected int count = 1;
    protected int rarity = 10;
    @SerializedName(value="min_y")
    protected int minY = 16;
    @SerializedName(value="max_y")
    protected int maxY = 64;
    @SerializedName(value="vertical_size")
    protected int verticalSize = 8;
    @SerializedName(value="horizontal_size")
    protected int horizontalSize = 15;
    protected float density = 20.0f;
    @SerializedName(value="dimensions_is_whitelist")
    protected boolean dimensionIsWhitelist = true;
    @SerializedName(value="biomes_is_whitelist")
    protected boolean biomesIsWhitelist = true;
    @SerializedName(value="stone")
    private List<IBlockState> stoneStates = null;
    @SerializedName(value="ore")
    private IWeightedList<IBlockState> oreStates = null;
    private List<String> biomes = null;
    private List<String> dimensions = null;
    private Indicator indicator = null;

    @Override
    @Nonnull
    public IBlockState getStateToGenerate(Random rand) {
        return this.oreStates.get(rand);
    }

    @Override
    @Nonnull
    public Collection<IBlockState> getOreStates() {
        return this.oreStates.values();
    }

    @Override
    @Nullable
    public Indicator getIndicator() {
        return this.indicator;
    }

    @Override
    public boolean canGenerateIn(IBlockState state) {
        return this.stoneStates.contains(state);
    }

    @Override
    public boolean inRange(V vein, int xOffset, int zOffset) {
        return (float)(xOffset * xOffset + zOffset * zOffset) < (float)(this.horizontalSize * this.horizontalSize) * ((AbstractVein)vein).getSize();
    }

    @Override
    public boolean matchesDimension(Dimension dimension) {
        ResourceLocation loc = IRegistry.field_212622_k.func_177774_c((Object)dimension.func_186058_p());
        if (loc == null) {
            System.out.println("Loc is null");
            return true;
        }
        String name = loc.toString();
        if (this.dimensions == null) {
            return "minecraft:overworld".equals(name);
        }
        for (String dim : this.dimensions) {
            if (!dim.equals(name)) continue;
            return this.dimensionIsWhitelist;
        }
        return !this.dimensionIsWhitelist;
    }

    @Override
    public boolean matchesBiome(Biome biome) {
        if (this.biomes == null) {
            return true;
        }
        for (String s : this.biomes) {
            String biomeName = biome.getRegistryName().func_110623_a();
            if (biomeName.equals(s)) {
                return this.biomesIsWhitelist;
            }
            for (BiomeDictionary.Type type : BiomeDictionary.getTypes((Biome)biome)) {
                if (!s.equalsIgnoreCase(type.getName())) continue;
                return this.biomesIsWhitelist;
            }
        }
        return !this.biomesIsWhitelist;
    }

    @Override
    public boolean isValid() {
        return this.oreStates != null && !this.oreStates.isEmpty() && this.stoneStates != null && !this.stoneStates.isEmpty() && (this.indicator == null || this.indicator.isValid()) && this.maxY > this.minY && this.minY >= 0 && this.count > 0 && this.rarity > 0 && this.verticalSize > 0 && this.horizontalSize > 0 && this.density > 0.0f;
    }

    @Override
    public int getMinY() {
        return this.minY;
    }

    @Override
    public int getMaxY() {
        return this.maxY;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public int getRarity() {
        return this.rarity;
    }

    @Override
    public int getChunkRadius() {
        return 1 + (this.horizontalSize >> 4);
    }

    public String toString() {
        return String.format("[%s: Count: %d, Rarity: %d, Y: %d - %d, Size: %d / %d, Density: %2.2f, Ores: %s, Stones: %s]", VeinRegistry.getName(this), this.count, this.rarity, this.minY, this.maxY, this.horizontalSize, this.verticalSize, Float.valueOf(this.density), this.oreStates, this.stoneStates);
    }

    protected final BlockPos defaultStartPos(int chunkX, int chunkZ, Random rand) {
        return new BlockPos(chunkX * 16 + rand.nextInt(16), this.minY + rand.nextInt(this.maxY - this.minY), chunkZ * 16 + rand.nextInt(16));
    }
}

