/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.oreveins.cmd;

import com.alcatrazescapee.oreveins.api.IVeinType;
import com.alcatrazescapee.oreveins.vein.VeinRegistry;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.WorldServer;

@ParametersAreNonnullByDefault
public final class CommandClearWorld {
    private static final Set<IBlockState> VEIN_STATES = new HashSet<IBlockState>();

    public static void resetVeinStates() {
        VeinRegistry.getVeins().stream().map(IVeinType::getOreStates).forEach(VEIN_STATES::addAll);
    }

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"clearworld").requires(source -> source.func_197034_c(2))).then(Commands.func_197056_a((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)250)).executes(cmd -> CommandClearWorld.clearWorld((CommandSource)cmd.getSource(), IntegerArgumentType.getInteger((CommandContext)cmd, (String)"radius")))));
    }

    private static int clearWorld(CommandSource source, int radius) {
        WorldServer world = source.func_197023_e();
        BlockPos center = new BlockPos(source.func_197036_d());
        IBlockState air = Blocks.field_150350_a.func_176223_P();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = 255 - center.func_177956_o(); y >= -center.func_177956_o(); --y) {
                    BlockPos pos = center.func_177982_a(x, y, z);
                    if (VEIN_STATES.contains(world.func_180495_p(pos)) || world.func_180495_p(pos) == air) continue;
                    world.func_180501_a(pos, air, 18);
                }
            }
        }
        source.func_197030_a((ITextComponent)new TextComponentString("Done."), true);
        return 1;
    }
}

