/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.oreveins.util;

import com.alcatrazescapee.oreveins.util.IWeightedList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.Random;
import java.util.TreeMap;
import javax.annotation.Nonnull;

public class WeightedList<E>
implements IWeightedList<E> {
    private double totalWeight = 0.0;
    private NavigableMap<Double, E> map = new TreeMap<Double, E>();

    @Override
    public void add(double weight, E element) {
        if (weight > 0.0) {
            this.totalWeight += weight;
            this.map.put(this.totalWeight, element);
        }
    }

    @Override
    public E get(Random random) {
        double value = random.nextDouble() * this.totalWeight;
        return this.map.higherEntry(value).getValue();
    }

    @Override
    public Collection<E> values() {
        return this.map.values();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    @Nonnull
    public Iterator<E> iterator() {
        return this.map.values().iterator();
    }
}

