/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.oreveins.util.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.state.IProperty;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockStateDeserializer
implements JsonDeserializer<IBlockState> {
    public IBlockState deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonPrimitive()) {
            String name = json.getAsString();
            return BlockStateDeserializer.getDefaultState(name);
        }
        if (json.isJsonObject()) {
            JsonObject jsonObj = json.getAsJsonObject();
            String name = jsonObj.get("block").getAsString();
            IBlockState state = BlockStateDeserializer.getDefaultState(name);
            for (IProperty prop : state.func_206869_a()) {
                state = BlockStateDeserializer.withProperty(state, jsonObj, prop);
            }
            return state;
        }
        throw new JsonParseException("IBlockState must be String or Object");
    }

    private static IBlockState getDefaultState(String blockName) throws JsonParseException {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockName));
        if (block == null) {
            throw new JsonParseException("Unrecognized Block: " + blockName);
        }
        return block.func_176223_P();
    }

    private static <T extends Comparable<T>> IBlockState withProperty(IBlockState base, JsonObject obj, IProperty<T> prop) {
        Optional propValue;
        String propName = prop.func_177701_a();
        if (obj.has(propName) && obj.get(propName).isJsonPrimitive() && (propValue = prop.func_185929_b(obj.get(propName).getAsString())).isPresent()) {
            return (IBlockState)base.func_206870_a(prop, (Comparable)propValue.get());
        }
        return base;
    }
}

