/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.oreveins.util.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.state.IBlockState;

public class BlockStateListDeserializer
implements JsonDeserializer<List<IBlockState>> {
    public List<IBlockState> deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonPrimitive() || json.isJsonObject()) {
            IBlockState state = (IBlockState)context.deserialize(json, IBlockState.class);
            return Collections.singletonList(state);
        }
        if (json.isJsonArray()) {
            JsonArray array = json.getAsJsonArray();
            ArrayList<IBlockState> states = new ArrayList<IBlockState>();
            for (JsonElement element : array) {
                states.add((IBlockState)context.deserialize(element, IBlockState.class));
            }
            return states;
        }
        throw new JsonParseException("Unable to parse IBlockState List");
    }
}

