/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.oreveins.util.json;

import com.alcatrazescapee.oreveins.api.IVeinType;
import com.alcatrazescapee.oreveins.vein.VeinTypeCluster;
import com.alcatrazescapee.oreveins.vein.VeinTypeCone;
import com.alcatrazescapee.oreveins.vein.VeinTypeCurve;
import com.alcatrazescapee.oreveins.vein.VeinTypePipe;
import com.alcatrazescapee.oreveins.vein.VeinTypeSphere;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class VeinTypeDeserializer
implements JsonDeserializer<IVeinType<?>> {
    private static final Map<String, Class<? extends IVeinType>> TYPES = new HashMap<String, Class<? extends IVeinType>>();

    public IVeinType<?> deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject obj = json.getAsJsonObject();
        String veinType = obj.get("type").getAsString();
        if (TYPES.containsKey(veinType)) {
            return (IVeinType)context.deserialize(json, (Type)TYPES.get(veinType));
        }
        throw new JsonParseException("Unknown vein type " + veinType);
    }

    static {
        TYPES.put("sphere", VeinTypeSphere.class);
        TYPES.put("cluster", VeinTypeCluster.class);
        TYPES.put("cone", VeinTypeCone.class);
        TYPES.put("pipe", VeinTypePipe.class);
        TYPES.put("curve", VeinTypeCurve.class);
    }
}

