/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.oreveins.util.json;

import com.alcatrazescapee.oreveins.util.IWeightedList;
import com.alcatrazescapee.oreveins.util.WeightedList;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import net.minecraft.block.state.IBlockState;

public class WeightedListDeserializer
implements JsonDeserializer<IWeightedList<IBlockState>> {
    public IWeightedList<IBlockState> deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonPrimitive() || json.isJsonObject()) {
            IBlockState state = (IBlockState)context.deserialize(json, IBlockState.class);
            return IWeightedList.singleton(state);
        }
        if (json.isJsonArray()) {
            JsonArray array = json.getAsJsonArray();
            WeightedList<IBlockState> states = new WeightedList<IBlockState>();
            for (JsonElement element : array) {
                JsonObject obj = element.getAsJsonObject();
                double weight = obj.has("weight") ? obj.get("weight").getAsDouble() : 1.0;
                states.add(weight, (IBlockState)context.deserialize(element, IBlockState.class));
            }
            return states;
        }
        throw new JsonParseException("Unable to parse IBlockState List");
    }
}

