/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.oreveins.vein;

import com.alcatrazescapee.oreveins.api.IVeinType;
import com.alcatrazescapee.oreveins.util.IWeightedList;
import com.alcatrazescapee.oreveins.util.json.BlockStateDeserializer;
import com.alcatrazescapee.oreveins.util.json.BlockStateListDeserializer;
import com.alcatrazescapee.oreveins.util.json.VeinTypeDeserializer;
import com.alcatrazescapee.oreveins.util.json.WeightedListDeserializer;
import com.google.common.base.Strings;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class VeinRegistry {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final BiMap<String, IVeinType> VEINS = HashBiMap.create();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(IVeinType.class, (Object)new VeinTypeDeserializer()).registerTypeAdapter(new TypeToken<List<IBlockState>>(){}.getType(), (Object)new BlockStateListDeserializer()).registerTypeAdapter(IWeightedList.class, (Object)new WeightedListDeserializer()).registerTypeAdapter(IBlockState.class, (Object)new BlockStateDeserializer()).create();

    public static Collection<IVeinType> getVeins() {
        return VEINS.values();
    }

    public static IVeinType getVein(String key) {
        return (IVeinType)VEINS.get((Object)key);
    }

    public static String getName(IVeinType key) {
        return (String)VEINS.inverse().get((Object)key);
    }

    public static void preInit() {
        LOGGER.info("Loading or creating ore generation config file");
        File configFolder = new File(System.getProperty("user.dir") + "/config", "oreveins");
        if (!configFolder.exists() && !configFolder.mkdir()) {
            LOGGER.warn("Problem creating Ore Veins config directory.");
        } else {
            File defaultFile = new File(configFolder, "ore_veins.json");
            String defaultData = null;
            if (defaultFile.exists()) {
                try {
                    defaultData = FileUtils.readFileToString((File)defaultFile, (Charset)Charset.defaultCharset());
                }
                catch (IOException e) {
                    LOGGER.warn("Error reading default file.", (Throwable)e);
                }
            }
            if (Strings.isNullOrEmpty(defaultData)) {
                try (BufferedWriter writer = Files.newBufferedWriter(defaultFile.toPath(), new OpenOption[0]);){
                    writer.write("{\n\n}");
                }
                catch (IOException e) {
                    LOGGER.warn("Error initializing default file", (Throwable)e);
                }
            }
        }
        File[] worldGenFiles = configFolder.listFiles((file, name) -> name != null && name.toLowerCase(Locale.US).endsWith(".json"));
        if (worldGenFiles == null) {
            LOGGER.warn("There are no valid files in the world gen folder, this mod will not do anything!");
        } else {
            for (File worldGenFile : worldGenFiles) {
                String worldGenData = null;
                if (worldGenFile.exists()) {
                    try {
                        worldGenData = FileUtils.readFileToString((File)worldGenFile, (Charset)Charset.defaultCharset());
                    }
                    catch (IOException e) {
                        LOGGER.warn("Error reading world gen file.", (Throwable)e);
                        continue;
                    }
                }
                if (Strings.isNullOrEmpty(worldGenData)) {
                    LOGGER.warn("There is no data in a world gen file.");
                    continue;
                }
                try {
                    Set allVeinsJson = new JsonParser().parse(worldGenData).getAsJsonObject().entrySet();
                    for (Map.Entry entry : allVeinsJson) {
                        try {
                            IVeinType vein = (IVeinType)GSON.fromJson((JsonElement)entry.getValue(), IVeinType.class);
                            if (vein.isValid()) {
                                VEINS.put(entry.getKey(), (Object)vein);
                                continue;
                            }
                            LOGGER.warn("Vein {} is invalid. This is likely caused by one or more required parameters being left out.", entry.getKey());
                        }
                        catch (Throwable e) {
                            LOGGER.warn("Vein {} failed to parse. This is most likely caused by incorrectly specified JSON.", entry.getKey());
                            LOGGER.warn("Error: ", e);
                        }
                    }
                }
                catch (Throwable e) {
                    LOGGER.warn("File {} failed to parse. This is most likely caused by invalid JSON. Error: {}", (Object)worldGenFile, (Object)e);
                    LOGGER.warn("Error: ", e);
                }
            }
        }
        LOGGER.info("Registered {} Veins Successfully.", (Object)VeinRegistry.getVeins().size());
    }

    private VeinRegistry() {
    }
}

