/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.oreveins.vein;

import com.alcatrazescapee.oreveins.api.AbstractVein;
import com.alcatrazescapee.oreveins.api.AbstractVeinType;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

@ParametersAreNonnullByDefault
public class VeinTypeCurve
extends AbstractVeinType<VeinCurve> {
    float radius = 5.0f;
    float angle = 45.0f;

    @Override
    public boolean inRange(VeinCurve vein, int xOffset, int zOffset) {
        return (float)xOffset < (float)this.horizontalSize * vein.getSize() && (float)zOffset < (float)this.horizontalSize * vein.getSize();
    }

    @Override
    public float getChanceToGenerate(VeinCurve vein, BlockPos pos) {
        for (CurveSegment segment : vein.getSegmentList()) {
            Vec3d blockPos = new Vec3d((Vec3i)pos);
            Vec3d centeredPos = blockPos.func_178788_d(segment.begin);
            double yaw = segment.yaw;
            Vec3d posX = new Vec3d(Math.cos(yaw) * centeredPos.field_72450_a + Math.sin(yaw) * centeredPos.field_72449_c, centeredPos.field_72448_b, -Math.sin(yaw) * centeredPos.field_72450_a + Math.cos(yaw) * centeredPos.field_72449_c);
            double pitch = segment.pitch;
            Vec3d posY = new Vec3d(Math.cos(pitch) * posX.field_72450_a - Math.sin(pitch) * posX.field_72448_b, Math.sin(pitch) * posX.field_72450_a + Math.cos(pitch) * posX.field_72448_b, posX.field_72449_c);
            double rad = Math.sqrt(posY.field_72450_a * posY.field_72450_a + posY.field_72449_c * posY.field_72449_c);
            double length = segment.length;
            if (!(posY.field_72448_b >= 0.0 && posY.field_72448_b <= length) && (!(posY.field_72448_b < 0.0) || !(posY.field_72448_b >= length)) || !(rad < (double)this.radius)) continue;
            return 0.005f * this.density * (1.0f - 0.9f * (float)rad / this.radius);
        }
        return 0.0f;
    }

    @Override
    @Nonnull
    public VeinCurve createVein(int chunkX, int chunkZ, Random rand) {
        int maxOffY = this.getMaxY() - this.getMinY() - this.verticalSize;
        int posY = this.getMinY() + this.verticalSize / 2 + (maxOffY > 0 ? rand.nextInt(maxOffY) : 0);
        BlockPos pos = new BlockPos(chunkX * 16 + rand.nextInt(16), posY, chunkZ * 16 + rand.nextInt(16));
        return new VeinCurve(this, pos, rand);
    }

    private static class CurveSegment {
        final Vec3d begin;
        final double length;
        final double yaw;
        final double pitch;

        CurveSegment(Vec3d begin, double length, double yaw, double pitch) {
            this.begin = begin;
            this.length = length;
            this.yaw = yaw;
            this.pitch = pitch;
        }
    }

    static class VeinCurve
    extends AbstractVein<VeinTypeCurve> {
        private final Random rand;
        private boolean isInitialized = false;
        private List<CurveSegment> segmentList;

        VeinCurve(VeinTypeCurve type, BlockPos pos, Random random) {
            super(type, pos, 0.5f * (1.0f + random.nextFloat()));
            this.rand = new Random(random.nextLong());
            this.segmentList = new ArrayList<CurveSegment>();
        }

        @Override
        public boolean inRange(int x, int z) {
            return ((VeinTypeCurve)this.getType()).inRange(this, this.getPos().func_177958_n() - x, this.getPos().func_177952_p() - z);
        }

        @Override
        public double getChanceToGenerate(@Nonnull BlockPos pos) {
            if (!this.isInitialized) {
                this.initialize(((VeinTypeCurve)this.getType()).horizontalSize, ((VeinTypeCurve)this.getType()).verticalSize, ((VeinTypeCurve)this.getType()).angle);
            }
            return ((VeinTypeCurve)this.getType()).getChanceToGenerate(this, pos);
        }

        List<CurveSegment> getSegmentList() {
            return this.segmentList;
        }

        private Vec3d getRandomPointInCuboid(Random rand, Vec3d bottomLeft, Vec3d topRight) {
            double x = bottomLeft.field_72450_a + (topRight.field_72450_a - bottomLeft.field_72450_a) * rand.nextDouble();
            double y = bottomLeft.field_72448_b + (topRight.field_72448_b - bottomLeft.field_72448_b) * rand.nextDouble();
            double z = bottomLeft.field_72449_c + (topRight.field_72449_c - bottomLeft.field_72449_c) * rand.nextDouble();
            return new Vec3d(x, y, z);
        }

        private void initialize(int hSize, int vSize, float angle) {
            double y1;
            double z1;
            double kxy = Math.tan(angle * (1.0f - 2.0f * this.rand.nextFloat()));
            double v2Size = (double)vSize / 2.0;
            double h2Size = (double)((float)hSize * this.size) / 2.0;
            double kyz = Math.tan(angle * (1.0f - 2.0f * this.rand.nextFloat()));
            if (v2Size >= h2Size * Math.abs(kyz)) {
                z1 = -h2Size;
                y1 = h2Size * kyz;
            } else {
                z1 = -v2Size * Math.abs(kyz);
                y1 = v2Size * Math.signum(kyz);
            }
            double x1 = 1.0 >= Math.abs(kxy) ? h2Size : h2Size * kxy;
            double x2 = -x1;
            double y2 = -y1;
            double z2 = -z1;
            Vec3d p1 = new Vec3d(x1 + (double)this.getPos().func_177958_n(), y1 + (double)this.getPos().func_177956_o(), z1 + (double)this.getPos().func_177952_p());
            Vec3d p4 = new Vec3d(x2 + (double)this.getPos().func_177958_n(), y2 + (double)this.getPos().func_177956_o(), z2 + (double)this.getPos().func_177952_p());
            Vec3d bottomLeft = new Vec3d(Math.min(p1.field_72450_a, p4.field_72450_a), Math.min(p1.field_72448_b, p4.field_72448_b), Math.min(p1.field_72449_c, p4.field_72449_c));
            Vec3d topRight = new Vec3d(Math.max(p1.field_72450_a, p4.field_72450_a), Math.max(p1.field_72448_b, p4.field_72448_b), Math.max(p1.field_72449_c, p4.field_72449_c));
            Vec3d p2 = this.getRandomPointInCuboid(this.rand, bottomLeft, topRight);
            Vec3d p3 = this.getRandomPointInCuboid(this.rand, bottomLeft, topRight);
            double step = 5.0 / h2Size;
            double t = 0.0;
            Vec3d pe = new Vec3d(0.0, 0.0, 0.0);
            while (t < 1.0) {
                Vec3d pb = t == 0.0 ? p1 : pe;
                if ((t += step) > 1.0) {
                    t = 1.0;
                }
                double t11 = 1.0 - t;
                double t12 = t11 * t11;
                double t13 = t12 * t11;
                double t31 = 3.0 * t;
                double t32 = 3.0 * t * t;
                double t3 = t * t * t;
                pe = p1.func_186678_a(t13).func_178787_e(p2.func_186678_a(t31 * t12).func_178787_e(p3.func_186678_a(t32 * t11).func_178787_e(p4.func_186678_a(t3))));
                Vec3d axis = pe.func_178788_d(pb);
                double yaw = Math.atan(axis.field_72449_c / axis.field_72450_a);
                Vec3d axisX = new Vec3d(Math.cos(yaw) * axis.field_72450_a + Math.sin(yaw) * axis.field_72449_c, axis.field_72448_b, -Math.sin(yaw) * axis.field_72450_a + Math.cos(yaw) * axis.field_72449_c);
                double pitch = Math.atan(axisX.field_72450_a / axisX.field_72448_b);
                Vec3d axisY = new Vec3d(Math.cos(pitch) * axisX.field_72450_a - Math.sin(pitch) * axisX.field_72448_b, Math.sin(pitch) * axisX.field_72450_a + Math.cos(pitch) * axisX.field_72448_b, axisX.field_72449_c);
                this.segmentList.add(new CurveSegment(pb, axisY.field_72448_b, yaw, pitch));
            }
            this.isInitialized = true;
        }
    }
}

