/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.oreveins.world;

import com.alcatrazescapee.oreveins.OreVeinsConfig;
import com.alcatrazescapee.oreveins.api.IVein;
import com.alcatrazescapee.oreveins.api.IVeinType;
import com.alcatrazescapee.oreveins.vein.Indicator;
import com.alcatrazescapee.oreveins.vein.VeinRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.IChunkGenSettings;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

@ParametersAreNonnullByDefault
public class FeatureVeins
extends Feature<NoFeatureConfig> {
    private static final Random RANDOM = new Random();
    private static int CHUNK_RADIUS = 0;

    public static void resetChunkRadius() {
        CHUNK_RADIUS = 1 + VeinRegistry.getVeins().stream().mapToInt(IVeinType::getChunkRadius).max().orElse(0) + OreVeinsConfig.INSTANCE.extraChunkRange;
    }

    @Nonnull
    public static List<IVein> getNearbyVeins(int chunkX, int chunkZ, long worldSeed, int radius) {
        ArrayList<IVein> veins = new ArrayList<IVein>();
        for (int x = chunkX - radius; x <= chunkX + radius; ++x) {
            for (int z = chunkZ - radius; z <= chunkZ + radius; ++z) {
                RANDOM.setSeed(worldSeed + (long)x * 341873128712L + (long)z * 132897987541L);
                FeatureVeins.getVeinsAtChunk(veins, x, z, worldSeed);
            }
        }
        return veins;
    }

    private static void getVeinsAtChunk(List<IVein> veins, int chunkX, int chunkZ, long worldSeed) {
        Random random = new Random(worldSeed + (long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        for (IVeinType type : VeinRegistry.getVeins()) {
            for (int i = 0; i < type.getCount(); ++i) {
                if (random.nextInt(type.getRarity()) != 0) continue;
                Object vein = type.createVein(chunkX, chunkZ, random);
                veins.add((IVein)vein);
            }
        }
    }

    public boolean place(IWorld world, IChunkGenerator<? extends IChunkGenSettings> chunkGenerator, Random random, BlockPos pos, NoFeatureConfig config) {
        List<IVein> veins = FeatureVeins.getNearbyVeins(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4, world.func_72905_C(), CHUNK_RADIUS);
        if (veins.isEmpty()) {
            return false;
        }
        for (IVein vein : veins) {
            if (!vein.getType().matchesDimension(world.func_201675_m())) continue;
            this.generate(world, random, pos.func_177958_n(), pos.func_177952_p(), vein);
        }
        return true;
    }

    private void generate(IWorld world, Random random, int xOff, int zOff, IVein<?> vein) {
        for (int x = xOff; x < 16 + xOff; ++x) {
            for (int z = zOff; z < 16 + zOff; ++z) {
                Biome biomeAt = world.func_180494_b(new BlockPos(x, 0, z));
                if (!vein.getType().matchesBiome(biomeAt) || !vein.inRange(x, z)) continue;
                Indicator veinIndicator = vein.getType().getIndicator();
                boolean canGenerateIndicator = false;
                for (int y = vein.getType().getMinY(); y <= vein.getType().getMaxY(); ++y) {
                    BlockPos posAt = new BlockPos(x, y, z);
                    if (!((double)random.nextFloat() < vein.getChanceToGenerate(posAt))) continue;
                    IBlockState stoneState = world.func_180495_p(posAt);
                    if (!vein.getType().canGenerateIn(stoneState)) continue;
                    IBlockState oreState = vein.getType().getStateToGenerate(random);
                    this.func_202278_a(world, posAt, oreState);
                    if (veinIndicator == null || canGenerateIndicator) continue;
                    int depth = world.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, x, z) - y;
                    if (depth < 0) {
                        depth = -depth;
                    }
                    canGenerateIndicator = depth < veinIndicator.getMaxDepth();
                }
                if (veinIndicator == null || !canGenerateIndicator || random.nextInt(veinIndicator.getRarity()) != 0) continue;
                BlockPos posAt = world.func_205770_a(Heightmap.Type.WORLD_SURFACE_WG, new BlockPos(x, 0, z));
                IBlockState indicatorState = veinIndicator.getStateToGenerate(random);
                IBlockState stateAt = world.func_180495_p(posAt);
                if (!indicatorState.func_196955_c((IWorldReaderBase)world, posAt) || !veinIndicator.shouldIgnoreLiquids() && stateAt.func_185904_a().func_76224_d() || !veinIndicator.validUnderState(world.func_180495_p(posAt.func_177977_b()))) continue;
                this.func_202278_a(world, posAt, indicatorState);
            }
        }
    }
}

