/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="regeneration", name="Regeneration")
public class RegenConfig {
    @Config.LangKey(value="config.regeneration.category.grace")
    public static final GracePeriod grace = new GracePeriod();
    @Config.LangKey(value="config.regeneration.category.compat")
    public static final ModIntegrations modIntegrations = new ModIntegrations();
    @Config.LangKey(value="config.regeneration.category.on_regen")
    public static final OnRegen onRegen = new OnRegen();
    @Config.LangKey(value="config.regeneration.category.post_regen")
    public static final PostRegen postRegen = new PostRegen();
    @Config.LangKey(value="config.regeneration.category.skins")
    public static final Skins skins = new Skins();
    @Config.LangKey(value="config.regeneration.max_regens")
    @Config.Comment(value={"The maximum regeneration capacity. This affects the durability of a Fob Watch and the amount of regenerations in a full cycle. Use 0 for infinite regenerations."})
    @Config.RequiresMcRestart
    @Config.RangeInt(min=0)
    public static int regenCapacity = 12;
    @Config.LangKey(value="config.regeneration.free_regens")
    @Config.Comment(value={"Every player will start with this number of regenerations. Will cause undefined behavior if bigger than the amount of regenerations per cycle."})
    @Config.RangeInt(min=0)
    public static int freeRegenerations = 0;
    @Config.LangKey(value="config.regeneration.first_start_gift_only")
    @Config.Comment(value={"Only give new players free regenerations"})
    public static boolean firstStartGiftOnly = true;
    @Config.LangKey(value="config.regeneration.lose_regens_on_death")
    @Config.Comment(value={"If this is false you won't lose your regenerations if you get killed during regeneration"})
    public static boolean loseRegensOnDeath = false;
    @Config.LangKey(value="config.regeneration.fiery_regen")
    @Config.Comment(value={"Spawn fire during regeneration"})
    public static boolean fieryRegen = true;
    @Config.LangKey(value="config.regeneration.regeneration_fire_immunity")
    @Config.Comment(value={"Players are immune to fire damage while regenerating"})
    public static boolean regenFireImmune = false;
    @Config.LangKey(value="config.regeneration.infinite_regenerations")
    @Config.Comment(value={"Players are always able to regenerate. Effectively makes the Fob Watch obsolete."})
    public static boolean infiniteRegeneration = false;
    @Config.LangKey(value="config.regeneration.regen_messages")
    @Config.Comment(value={"Sends a message to chat to say that a player is regenerating, and the reason for it"})
    public static boolean sendRegenDeathMessages = true;
    @Config.LangKey(value="config.regeneration.perspective")
    @Config.Comment(value={"Changes the players perspective on regeneration"})
    public static boolean changePerspective = true;
    @Config.LangKey(value="config.regeneration.update_checker")
    @Config.Comment(value={"Display a notification in chat when there's an update to the mod"})
    public static boolean enableUpdateChecker = true;
    @Config.LangKey(value="config.regeneration.hand_change")
    @Config.Comment(value={"Toggle whether your hand has the chance of inverting after a regen"})
    public static boolean changeHand = true;
    @Config.LangKey(value="config.regeneration.craft")
    @Config.Comment(value={"Toggle whether Fob watches are full when crafted"})
    public static boolean craftWithRegens = true;
    @Config.LangKey(value="config.regeneration.shaders")
    @Config.Comment(value={"Toggle whether cool shaders become applied when Regenerating"})
    public static boolean regenerationShaders = true;
    @Config.Comment(value={"Toggle whether cool bar things display when Regenerating"})
    public static boolean coolCustomBarThings = true;

    @Mod.EventBusSubscriber
    public static class EventHandler {
        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("regeneration")) {
                ConfigManager.sync((String)"regeneration", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class ModIntegrations {
        @Config.LangKey(value="config.regeneration.category.compat.lccore")
        public final LucraftCore lucraftcore = new LucraftCore();
        @Config.LangKey(value="config.regeneration.category.compat.tardis")
        public final TardisMod tardisMod = new TardisMod();

        public static class TardisMod {
            @Config.LangKey(value="config.regeneration.compat.tardis.tardis_damage")
            @Config.Comment(value={"If this is true and The Tardis mod is installed, it's systems will be slightly damaged"})
            public boolean damageTardis = true;
        }

        public static class LucraftCore {
            @Config.LangKey(value="config.regeneration.compat.lccore.radiation_immunity")
            @Config.Comment(value={"If this is true and LCCore is installed, timelords are immune to radiation"})
            public boolean immuneToRadiation = true;
            @Config.LangKey(value="config.regeneration.compat.lccore.superpower_disable")
            @Config.Comment(value={"If this is true and LCCore is installed, you cannot regenerate while you have a superpower"})
            public boolean superpowerDisable = true;
        }
    }

    public static class GracePeriod {
        @Config.LangKey(value="config.regeneration.grace.gracePeriodLength")
        @Config.Comment(value={"The time in seconds before your grace period enters a critical phase"})
        @Config.RangeInt(min=0)
        public int gracePhaseLength = 900;
        @Config.LangKey(value="config.regeneration.grace.criticalPhaseLength")
        @Config.Comment(value={"The time in seconds you can stay in the critical phase without dying"})
        @Config.RangeInt(min=0)
        public int criticalPhaseLength = 60;
        @Config.LangKey(value="config.regeneration.grace.criticalDamageChance")
        @Config.Comment(value={"Chance that a player in critical phase gets damaged at a given tick. Higher number means more damage."})
        @Config.RangeInt(min=0)
        public float criticalDamageChance = 1.0f;
        @Config.LangKey(value="config.regeneration.grace.handGlowInterval")
        @Config.Comment(value={"Interval (in seconds) at which your hands start to glow"})
        @Config.RangeInt(min=0)
        public int handGlowInterval = 120;
        @Config.LangKey(value="config.regeneration.grace.handGlowTriggerDelay")
        @Config.Comment(value={"Amount of time (in seconds) you have when your hands start glowing before you start to regenerate"})
        @Config.RangeInt(min=0)
        public int handGlowTriggerDelay = 10;
    }

    public static class Skins {
        @Config.LangKey(value="config.regeneration.skins.changemyskin")
        @Config.Comment(value={"Disabling this will disable skin changing for you and you will retain your Mojang one"})
        public boolean changeMySkin = true;
        @Config.LangKey(value="config.regeneration.skins.folder")
        @Config.Comment(value={"This is where the regeneration skin folder will be generated, the default is './mods/', the path MUST NOT end in /"})
        @Config.RequiresMcRestart
        public String skinDir = "./mods";
        @Config.LangKey(value="config.regeneration.skins.trending")
        @Config.Comment(value={"Toggle whether trending skins are downloaded once per day from namemc"})
        public boolean downloadTrendingSkins = true;
        @Config.LangKey(value="config.regeneration.skins.past_skins")
        @Config.Comment(value={"Toggle whether the users past skins are downloaded once per day from namemc"})
        public boolean downloadPastSkins = true;
        @Config.LangKey(value="config.regeneration.skins.internal_skins")
        @Config.Comment(value={"Toggle whether the mod downloads its own batch of skins"})
        public boolean downloadInternalSkins = true;
    }

    public static class PostRegen {
        @Config.LangKey(value="config.regeneration.post_regen_duration")
        @Config.Comment(value={"Amount of seconds the post-regeneration effect lasts"})
        @Config.RangeInt(min=0)
        public int postRegenerationDuration = 180;
        @Config.LangKey(value="config.regeneration.post_regenerationEffect_level")
        @Config.Comment(value={"The level of the regeneration status effect granted after you regenerate"})
        @Config.RangeInt(min=0)
        public int postRegenerationLevel = 4;
        @Config.LangKey(value="config.regeneration.post_regenerationLindos_interval")
        @Config.Comment(value={"Amount of seconds between each check for \"burping\" out a Lindos particle, 0 to disable"})
        @Config.RangeInt(min=0)
        public int postRegenerationLindosInterval = 80;
        @Config.LangKey(value="config.regeneration.post_regenerationLindos_chance_extra")
        @Config.Comment(value={"The chance for a lindos particle to be \"burped\" out every interval"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double lindosChancePerInterval = 0.5;
        @Config.LangKey(value="config.regeneration.post_regenerationLindos_chance")
        @Config.Comment(value={"The chance for a lindos particle to spawn when the post phase ends"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double lindosChance = 0.5;
        @Config.LangKey(value="config.regeneration.reset_hunger")
        @Config.Comment(value={"Regenerate hunger bars"})
        public boolean resetHunger = true;
        @Config.LangKey(value="config.regeneration.reset_oxygen")
        @Config.Comment(value={"Regenerate Oxygen"})
        public boolean resetOxygen = true;
        @Config.LangKey(value="config.regeneration.absorbtion_level")
        @Config.Comment(value={"The amount of absorption hearts you get when regenerating"})
        @Config.RangeInt(min=0)
        public int absorbtionLevel = 10;
        @Config.LangKey(value="config.regeneration.post_grater")
        @Config.Comment(value={"Create a creator when falling from a great height in POST"})
        public boolean genGreator = false;
    }

    public static class OnRegen {
        @Config.LangKey(value="config.regeneration.regenerative_kill_range")
        @Config.Comment(value={"Upon regeneration every mob inside of this radius is immediately killed. Keep in mind that you should round up to accommodate for mobs that aren't standing in the center of a block"})
        @Config.RangeInt(min=0)
        public int regenerativeKillRange = 4;
        @Config.LangKey(value="config.regeneration.regenerative_knockback")
        @Config.Comment(value={"The amount of knockback every mob inside of the knock back radius gets"})
        public float regenerativeKnockback = 2.5f;
        @Config.LangKey(value="config.regeneration.regenerative_knockback_range")
        @Config.Comment(value={"Range wherein every mob is knocked back upon regeneration"})
        @Config.RangeInt(min=0)
        public int regenerativeKnockbackRange = 7;
        @Config.LangKey(value="config.regeneration.regeneration_knocksback_players")
        @Config.Comment(value={"Players can be knocked back when too close to a regeneration"})
        public boolean regenerationKnocksbackPlayers = true;
        @Config.LangKey(value="config.regeneration.regeneration_kills_players")
        @Config.Comment(value={"Players can be killed when too close to a regeneration"})
        public boolean regenerationKillsPlayers = false;
        @Config.LangKey(value="config.regeneration.traits")
        @Config.Comment(value={"Toggle whether traits are enabled"})
        public boolean traitsEnabled = true;
    }
}

