/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.asm;

import me.swirtzly.regeneration.RegenerationMod;
import me.swirtzly.regeneration.asm.RegenerationPlugin;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class RegenClassTransformer
implements IClassTransformer,
Opcodes {
    private static final String SOURCE_LWJGL_NAME = "paulscode/sound/libraries/SourceLWJGLOpenAL";
    private static final String CHANNEL_LWJGL_NAME = "paulscode/sound/libraries/ChannelLWJGLOpenAL";
    private static final String REGEN_HOOKS_CLASS = "me/swirtzly/regeneration/asm/RegenClientHooks";

    public static byte[] transformSoundSource(byte[] data) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(data);
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode method : classNode.methods) {
            if (!method.name.equals("play")) continue;
            RegenerationPlugin.insertBefore(method.instructions, RegenerationPlugin.invoke(SOURCE_LWJGL_NAME, "checkPitch"::equals), () -> {
                InsnList instructions = new InsnList();
                instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                instructions.add((AbstractInsnNode)new FieldInsnNode(180, SOURCE_LWJGL_NAME, "channelOpenAL", "Lpaulscode/sound/libraries/ChannelLWJGLOpenAL;"));
                instructions.add((AbstractInsnNode)new FieldInsnNode(180, CHANNEL_LWJGL_NAME, "ALSource", "Ljava/nio/IntBuffer;"));
                instructions.add((AbstractInsnNode)new InsnNode(3));
                instructions.add((AbstractInsnNode)new MethodInsnNode(182, "java/nio/IntBuffer", "get", "(I)I", false));
                instructions.add((AbstractInsnNode)new MethodInsnNode(184, "me/swirtzly/regeneration/asm/SoundReverbHandler", "onPlaySound", "(I)V", false));
                return instructions;
            });
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public static byte[] patchShader(byte[] bytes) {
        String shaderMethod = RegenerationMod.isDevEnv() ? "loadEntityShader" : "func_175066_a";
        String shaderMethodDesc = "(Lnet/minecraft/entity/Entity;)V";
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        for (int j = 0; j < classNode.methods.size(); ++j) {
            MethodNode method = (MethodNode)classNode.methods.get(j);
            if (!shaderMethod.equals(method.name) || !shaderMethodDesc.equals(method.desc)) continue;
            for (AbstractInsnNode anode : method.instructions) {
                if (anode.getOpcode() != 177) continue;
                InsnList newInstructions = new InsnList();
                newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, REGEN_HOOKS_CLASS, "handleShader", "()V", false));
                method.instructions.insertBefore(anode, newInstructions);
            }
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public static byte[] patchModelBiped(byte[] bytes) {
        String renderMethod = RegenerationMod.isDevEnv() ? "setRotationAngles" : "func_78087_a";
        String renderDesc = "(FFFFFFLnet/minecraft/entity/Entity;)V";
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        for (int j = 0; j < classNode.methods.size(); ++j) {
            MethodNode method = (MethodNode)classNode.methods.get(j);
            if (!renderMethod.equals(method.name) || !renderDesc.equals(method.desc)) continue;
            for (AbstractInsnNode anode : method.instructions) {
                if (anode.getOpcode() != 177) continue;
                InsnList newInstructions = new InsnList();
                newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                newInstructions.add((AbstractInsnNode)new VarInsnNode(23, 1));
                newInstructions.add((AbstractInsnNode)new VarInsnNode(23, 2));
                newInstructions.add((AbstractInsnNode)new VarInsnNode(23, 3));
                newInstructions.add((AbstractInsnNode)new VarInsnNode(23, 4));
                newInstructions.add((AbstractInsnNode)new VarInsnNode(23, 5));
                newInstructions.add((AbstractInsnNode)new VarInsnNode(23, 6));
                newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 7));
                newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, REGEN_HOOKS_CLASS, "handleRotations", "(Lnet/minecraft/client/model/ModelBiped;FFFFFFLnet/minecraft/entity/Entity;)V", false));
                method.instructions.insertBefore(anode, newInstructions);
            }
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public static byte[] patchRenderLivingBase(byte[] bytes) {
        String targetMethodName = RegenerationMod.isDevEnv() ? "prepareScale" : "func_188322_c";
        String targetScaleMethodname = RegenerationMod.isDevEnv() ? "scale" : "func_179152_a";
        String targetIsnName = "(Lnet/minecraft/entity/EntityLivingBase;F)F";
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        block0: for (int i = 0; i < classNode.methods.size(); ++i) {
            MethodNode method = (MethodNode)classNode.methods.get(i);
            if (!targetMethodName.equals(method.name) || !targetIsnName.equals(method.desc)) continue;
            InsnList insnList = method.instructions;
            for (int j = 0; j < insnList.size(); ++j) {
                AbstractInsnNode insnNote = method.instructions.get(j);
                if (insnNote.getOpcode() != 184) continue;
                MethodInsnNode method_0 = (MethodInsnNode)insnNote;
                if (!targetScaleMethodname.contains(method_0.name)) continue;
                InsnList insnList_0 = new InsnList();
                insnList_0.add((AbstractInsnNode)new VarInsnNode(25, 0));
                insnList_0.add((AbstractInsnNode)new VarInsnNode(25, 1));
                String parameter = "(Lnet/minecraft/client/renderer/entity/RenderLivingBase;Lnet/minecraft/entity/EntityLivingBase;)V";
                MethodInsnNode method_1 = new MethodInsnNode(184, REGEN_HOOKS_CLASS, "preRenderCallBack", parameter, false);
                insnList_0.add((AbstractInsnNode)method_1);
                insnList.insert((AbstractInsnNode)method_0, insnList_0);
                break block0;
            }
            break;
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchLighting(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        String methodName = RegenerationMod.isDevEnv() ? "updateLightMap" : "func_78472_g";
        MethodNode updateLightmap = null;
        for (MethodNode mn : classNode.methods) {
            if (!mn.name.toLowerCase().equals(methodName.toLowerCase())) continue;
            updateLightmap = mn;
        }
        Float m0 = new Float("0.95");
        Float m3 = new Float("0.96");
        Float a0 = new Float("0.05");
        Float a3 = new Float("0.03");
        if (updateLightmap != null) {
            for (int i = 0; i < updateLightmap.instructions.size(); ++i) {
                AbstractInsnNode an = updateLightmap.instructions.get(i);
                if (an instanceof LdcInsnNode) {
                    LdcInsnNode lin = (LdcInsnNode)an;
                    if (lin.cst.equals(m0) || lin.cst.equals(m3)) {
                        updateLightmap.instructions.insert((AbstractInsnNode)lin, (AbstractInsnNode)new MethodInsnNode(184, REGEN_HOOKS_CLASS, "up", "(F)F", false));
                        continue;
                    }
                    if (!lin.cst.equals(a0) && !lin.cst.equals(a3)) continue;
                    updateLightmap.instructions.insert((AbstractInsnNode)lin, (AbstractInsnNode)new MethodInsnNode(184, REGEN_HOOKS_CLASS, "down", "(F)F", false));
                    continue;
                }
                if (an instanceof FieldInsnNode) {
                    FieldInsnNode fin = (FieldInsnNode)an;
                    if (!fin.name.equals(RegenerationMod.isDevEnv() ? "gammaSetting" : "field_74333_Y")) continue;
                    updateLightmap.instructions.insert((AbstractInsnNode)fin, (AbstractInsnNode)new MethodInsnNode(184, REGEN_HOOKS_CLASS, "overrideGamma", "(F)F", false));
                    continue;
                }
                if (!(an instanceof MethodInsnNode)) continue;
                MethodInsnNode min = (MethodInsnNode)an;
                if (!min.name.equals(RegenerationMod.isDevEnv() ? "updateDynamicTexture" : "func_110564_a")) continue;
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                String lightmapColors = RegenerationMod.isDevEnv() ? "lightmapColors" : "field_78504_Q";
                toInsert.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/client/renderer/EntityRenderer", lightmapColors, "[I"));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, REGEN_HOOKS_CLASS, "modifyLightmap", "([I)[I", false));
                toInsert.add((AbstractInsnNode)new FieldInsnNode(181, "net/minecraft/client/renderer/EntityRenderer", lightmapColors, "[I"));
                updateLightmap.instructions.insertBefore((AbstractInsnNode)min, toInsert);
                i += 5;
            }
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return RegenClassTransformer.patchShader(writer.toByteArray());
    }

    public byte[] transform(String name, String transformedName, byte[] data) {
        if (data == null) {
            return null;
        }
        if (transformedName.equals("paulscode.sound.libraries.SourceLWJGLOpenAL")) {
            return RegenClassTransformer.transformSoundSource(data);
        }
        if (transformedName.equals("net.minecraft.client.model.ModelBiped")) {
            return RegenClassTransformer.patchModelBiped(data);
        }
        if (transformedName.equals("net.minecraft.client.renderer.EntityRenderer")) {
            return this.patchLighting(data);
        }
        if (transformedName.equals("net.minecraft.client.renderer.entity.RenderLivingBase")) {
            return RegenClassTransformer.patchRenderLivingBase(data);
        }
        return data;
    }
}

