/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.asm;

import java.awt.Color;
import me.swirtzly.regeneration.RegenConfig;
import me.swirtzly.regeneration.client.ClientEventHandler;
import me.swirtzly.regeneration.client.animation.ModelRotationEvent;
import me.swirtzly.regeneration.client.animation.RenderCallbackEvent;
import me.swirtzly.regeneration.common.capability.CapabilityRegeneration;
import me.swirtzly.regeneration.common.capability.IRegeneration;
import me.swirtzly.regeneration.util.PlayerUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class RegenClientHooks {
    public static int colorModeCache;
    public static float savedGreen;
    public static float savedRed;
    public static float savedBlue;
    private static int[] postShaders;

    public static void handleRotations(ModelBiped model, float f, float f1, float f2, float f3, float f4, float f5, Entity entity) {
        if (entity == null) {
            return;
        }
        ModelRotationEvent rotationEvent = new ModelRotationEvent(entity, model, f, f1, f2, f3, f4, f5);
        MinecraftForge.EVENT_BUS.post((Event)rotationEvent);
    }

    public static void preRenderCallBack(RenderLivingBase renderer, EntityLivingBase entity) {
        if (entity == null) {
            return;
        }
        RenderCallbackEvent ev = new RenderCallbackEvent(entity, (RenderLivingBase<EntityLivingBase>)renderer);
        MinecraftForge.EVENT_BUS.post((Event)ev);
    }

    public static void handleShader() {
        if (Minecraft.func_71410_x().field_71439_g == null || !RegenConfig.regenerationShaders) {
            return;
        }
        EntityRenderer entityRender = Minecraft.func_71410_x().field_71460_t;
        if (OpenGlHelper.field_148824_g) {
            Entity entity = Minecraft.func_71410_x().func_175606_aa();
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                IRegeneration data = CapabilityRegeneration.getForPlayer(player);
                switch (data.getState()) {
                    case POST: {
                        int shader = postShaders[entity.field_70170_p.field_73012_v.nextInt(postShaders.length)];
                        entityRender.func_175069_a(ClientEventHandler.SHADERS_TEXTURES[shader]);
                        break;
                    }
                    case GRACE: 
                    case GRACE_CRIT: {
                        entityRender.func_175069_a(ClientEventHandler.SHADERS_TEXTURES[16]);
                        break;
                    }
                    case ALIVE: 
                    case REGENERATING: {
                        RegenClientHooks.resetShader(entityRender);
                    }
                }
            } else {
                RegenClientHooks.resetShader(entityRender);
            }
        }
    }

    public static void resetShader(EntityRenderer entityRender) {
        Entity entityIn = Minecraft.func_71410_x().func_175606_aa();
        entityRender.func_181022_b();
        if (entityIn instanceof EntityCreeper) {
            entityRender.func_175069_a(new ResourceLocation("shaders/post/creeper.json"));
        } else if (entityIn instanceof EntitySpider) {
            entityRender.func_175069_a(new ResourceLocation("shaders/post/spider.json"));
        } else if (entityIn instanceof EntityEnderman) {
            entityRender.func_175069_a(new ResourceLocation("shaders/post/invert.json"));
        } else {
            ForgeHooksClient.loadEntityShader((Entity)entityIn, (EntityRenderer)entityRender);
        }
    }

    public static float modRed(float red) {
        if (!RegenClientHooks.enabled()) {
            return red;
        }
        if (colorModeCache == 1) {
            red = savedRed = Math.min(1.0f, red + 0.1f);
        }
        savedRed = red;
        return red;
    }

    public static float modGreen(float green) {
        if (!RegenClientHooks.enabled()) {
            return green;
        }
        savedGreen = green;
        if (savedRed > green) {
            return Math.max(savedRed, green);
        }
        if (savedRed < green) {
            return Math.min(savedRed, green);
        }
        return green;
    }

    public static float modBlue(float blue) {
        if (!RegenClientHooks.enabled()) {
            return blue;
        }
        savedBlue = blue;
        if (savedRed > blue) {
            return Math.max(savedRed, blue);
        }
        if (savedRed < blue) {
            return Math.min(savedRed, blue);
        }
        return blue;
    }

    public static int[] modifyLightmap(int[] original) {
        if (!RegenClientHooks.enabled()) {
            return original;
        }
        colorModeCache = 1;
        if (Minecraft.func_71410_x().field_71439_g.func_70644_a(MobEffects.field_76439_r) && colorModeCache == 0) {
            for (int i = 0; i < original.length; ++i) {
                int height = i / 16;
                if (height == 0 || height >= 16) continue;
                Color color = new Color(original[i]);
                Color newColor = new Color(RegenClientHooks.modRed(0.003921569f * (float)color.getRed()), RegenClientHooks.modGreen(0.003921569f * (float)color.getGreen()), RegenClientHooks.modBlue(0.003921569f * (float)color.getBlue()));
                original[i] = newColor.getRGB();
            }
        }
        return original;
    }

    public static float up(float f) {
        if (RegenClientHooks.enabled()) {
            return 1.0f;
        }
        return f;
    }

    public static float down(float f) {
        if (RegenClientHooks.enabled()) {
            return 0.0f;
        }
        return f;
    }

    private static boolean enabled() {
        if (Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().func_175606_aa() instanceof EntityPlayer) {
            return CapabilityRegeneration.getForPlayer((EntityPlayer)Minecraft.func_71410_x().func_175606_aa()).getState() == PlayerUtil.RegenState.GRACE_CRIT;
        }
        return false;
    }

    public static float overrideGamma(float original) {
        if (RegenClientHooks.enabled()) {
            return -4.0f;
        }
        return original;
    }

    static {
        postShaders = new int[]{19, 18, 7, 12, 20};
    }
}

