/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.asm;

import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import me.swirtzly.regeneration.RegenerationMod;
import me.swirtzly.regeneration.asm.RegenClassTransformer;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;

@IFMLLoadingPlugin.Name(value="Regeneration")
@IFMLLoadingPlugin.TransformerExclusions(value={"me.swirtzly.regeneration.asm"})
@IFMLLoadingPlugin.SortingIndex(value=1001)
@IFMLLoadingPlugin.MCVersion(value="1.12.2")
public class RegenerationPlugin
implements IFMLLoadingPlugin {
    public static void insertBefore(InsnList instructions, Predicate<AbstractInsnNode> predicate, Supplier<InsnList> insert) {
        AbstractInsnNode node = RegenerationPlugin.selectNode(instructions, predicate);
        if (node != null) {
            instructions.insertBefore(node, insert.get());
        } else {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            RegenerationMod.LOG.warn("Failed to find location to insert for {}", (Object)stackTrace[1].getMethodName());
        }
    }

    @Nullable
    private static AbstractInsnNode selectNode(InsnList instructions, Predicate<AbstractInsnNode> predicate) {
        for (AbstractInsnNode node : instructions) {
            if (!predicate.test(node)) continue;
            return node;
        }
        return null;
    }

    public static Predicate<AbstractInsnNode> invoke(String owner, Predicate<String> name) {
        return n -> n instanceof MethodInsnNode && ((MethodInsnNode)n).owner.equals(owner) && name.test(((MethodInsnNode)n).name);
    }

    public String[] getASMTransformerClass() {
        return new String[]{RegenClassTransformer.class.getName()};
    }

    public String getModContainerClass() {
        return null;
    }

    @Nullable
    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
    }

    public String getAccessTransformerClass() {
        return null;
    }
}

