/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.client;

import me.swirtzly.regeneration.common.capability.CapabilityRegeneration;
import me.swirtzly.regeneration.common.capability.IRegeneration;
import me.swirtzly.regeneration.util.PlayerUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.input.Mouse;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class CameraHandler {
    private static float prevYaw = 0.0f;
    private static float prevPitch = 0.0f;
    private static float cameraRoll = 0.0f;
    private static float playerOriginaLook = 0.0f;
    private static float playerOriginalPitch = 0.0f;
    private static float playerOriginalYawHead = 0.0f;
    private static int playerOriginalSlotId = 0;
    private static float originalFOV = 0.0f;
    private static boolean initFreeCam = true;
    private static boolean pendingExit = false;

    @SubscribeEvent
    public static void onView(EntityViewRenderEvent.CameraSetup event) {
        boolean allowFreemode;
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        GameSettings gameSettings = mc.field_71474_y;
        IRegeneration data = CapabilityRegeneration.getForPlayer((EntityPlayer)player);
        boolean bl = allowFreemode = data.getState() == PlayerUtil.RegenState.REGENERATING || data.isSyncingToJar();
        if (allowFreemode) {
            if (gameSettings.field_74370_x.func_151470_d()) {
                cameraRoll += 1.0f;
            }
            if (gameSettings.field_74366_z.func_151470_d()) {
                cameraRoll -= 1.0f;
            }
        }
        if (data.getState() != PlayerUtil.RegenState.REGENERATING) {
            cameraRoll = 0.0f;
        }
        event.setRoll(cameraRoll);
        if (allowFreemode) {
            pendingExit = true;
            if (initFreeCam) {
                playerOriginaLook = player.field_70177_z;
                playerOriginalPitch = player.field_70125_A;
                playerOriginalYawHead = player.field_70759_as;
                originalFOV = gameSettings.field_74334_X;
                playerOriginalSlotId = player.field_71071_by.field_70461_c;
            }
            player.field_70177_z = playerOriginaLook;
            player.field_70125_A = playerOriginalPitch;
            player.field_70759_as = playerOriginalYawHead;
            double sensitivity = Math.pow(gameSettings.field_74341_c * 0.6f + 0.2f, 3.0) * 8.0;
            double deltaX = (double)mc.field_71417_B.field_74377_a * sensitivity * 0.15;
            double deltaY = (double)(-mc.field_71417_B.field_74375_b) * sensitivity * 0.15;
            event.setYaw((float)deltaX + prevYaw + playerOriginaLook - 180.0f);
            event.setPitch((float)deltaY + prevPitch + player.field_70125_A);
            prevYaw = (float)deltaX + prevYaw;
            prevPitch = (float)deltaY + prevPitch;
            player.field_71071_by.field_70461_c = playerOriginalSlotId;
            CameraHandler.manipulateFov(gameSettings, sensitivity);
            initFreeCam = false;
        } else if (pendingExit) {
            CameraHandler.resetEverything(gameSettings);
        }
    }

    private static void manipulateFov(GameSettings gameSettings, double sensitivity) {
        int prevScrollWheelKnot = 0;
        prevScrollWheelKnot += Mouse.getDWheel();
        while (prevScrollWheelKnot >= 120) {
            prevScrollWheelKnot -= 120;
            gameSettings.field_74334_X = (float)((double)gameSettings.field_74334_X - sensitivity * 4.0);
        }
        while (prevScrollWheelKnot <= -120) {
            prevScrollWheelKnot += 120;
            gameSettings.field_74334_X = (float)((double)gameSettings.field_74334_X + sensitivity * 4.0);
        }
        if (gameSettings.field_74334_X < 20.0f) {
            gameSettings.field_74334_X = 20.0f;
        }
        if (gameSettings.field_74334_X > 140.0f) {
            gameSettings.field_74334_X = 140.0f;
        }
        if (gameSettings.field_74334_X > 120.0f && gameSettings.field_74320_O == 0) {
            gameSettings.field_74320_O = 1;
            gameSettings.field_74334_X = 40.0f;
        }
        if (gameSettings.field_74334_X < 40.0f && gameSettings.field_74320_O == 1) {
            gameSettings.field_74320_O = 0;
            gameSettings.field_74334_X = 120.0f;
        }
    }

    public static void resetEverything(GameSettings gameSettings) {
        initFreeCam = true;
        prevYaw = 0.0f;
        prevPitch = 0.0f;
        gameSettings.field_74334_X = originalFOV;
        pendingExit = false;
    }
}

