/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.client;

import java.util.ArrayList;
import java.util.Random;
import java.util.UUID;
import me.swirtzly.regeneration.RegenConfig;
import me.swirtzly.regeneration.asm.RegenClientHooks;
import me.swirtzly.regeneration.client.animation.AnimationContext;
import me.swirtzly.regeneration.client.animation.AnimationHandler;
import me.swirtzly.regeneration.client.animation.ModelRotationEvent;
import me.swirtzly.regeneration.client.animation.RenderCallbackEvent;
import me.swirtzly.regeneration.client.gui.GuiPreferences;
import me.swirtzly.regeneration.client.gui.parts.InventoryTabRegeneration;
import me.swirtzly.regeneration.client.rendering.types.ATypeRenderer;
import me.swirtzly.regeneration.client.skinhandling.SkinChangingHandler;
import me.swirtzly.regeneration.common.capability.CapabilityRegeneration;
import me.swirtzly.regeneration.common.capability.IRegeneration;
import me.swirtzly.regeneration.common.item.ItemArchInterface;
import me.swirtzly.regeneration.common.item.arch.capability.CapabilityArch;
import me.swirtzly.regeneration.common.item.arch.capability.IArch;
import me.swirtzly.regeneration.common.traits.DnaHandler;
import me.swirtzly.regeneration.common.types.TypeHandler;
import me.swirtzly.regeneration.handlers.RegenObjects;
import me.swirtzly.regeneration.util.ClientUtil;
import me.swirtzly.regeneration.util.EnumCompatModids;
import me.swirtzly.regeneration.util.PlayerUtil;
import me.swirtzly.regeneration.util.RenderUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="regeneration")
public class ClientEventHandler {
    public static final ResourceLocation[] SHADERS_TEXTURES = new ResourceLocation[]{new ResourceLocation("shaders/post/notch.json"), new ResourceLocation("shaders/post/fxaa.json"), new ResourceLocation("shaders/post/art.json"), new ResourceLocation("shaders/post/bumpy.json"), new ResourceLocation("shaders/post/blobs2.json"), new ResourceLocation("shaders/post/pencil.json"), new ResourceLocation("shaders/post/color_convolve.json"), new ResourceLocation("shaders/post/deconverge.json"), new ResourceLocation("shaders/post/flip.json"), new ResourceLocation("shaders/post/invert.json"), new ResourceLocation("shaders/post/ntsc.json"), new ResourceLocation("shaders/post/outline.json"), new ResourceLocation("shaders/post/phosphor.json"), new ResourceLocation("shaders/post/scan_pincushion.json"), new ResourceLocation("shaders/post/sobel.json"), new ResourceLocation("shaders/post/bits.json"), new ResourceLocation("shaders/post/desaturate.json"), new ResourceLocation("shaders/post/green.json"), new ResourceLocation("shaders/post/blur.json"), new ResourceLocation("shaders/post/wobble.json"), new ResourceLocation("shaders/post/blobs.json"), new ResourceLocation("shaders/post/antialias.json"), new ResourceLocation("shaders/post/creeper.json"), new ResourceLocation("shaders/post/spider.json")};
    public static final ResourceLocation TEX = new ResourceLocation("regeneration", "textures/gui/widgets.png");
    public static EnumHandSide SIDE = null;

    @SubscribeEvent
    public static void onColorFog(EntityViewRenderEvent.FogColors e) {
        IRegeneration data;
        if (Minecraft.func_71410_x().func_175606_aa() instanceof EntityPlayer && (data = CapabilityRegeneration.getForPlayer((EntityPlayer)Minecraft.func_71410_x().field_71439_g)).getType() == TypeHandler.RegenType.LAY_FADE && data.getState() == PlayerUtil.RegenState.REGENERATING) {
            e.setRed((float)data.getPrimaryColor().field_72450_a);
            e.setGreen((float)data.getPrimaryColor().field_72448_b);
            e.setBlue((float)data.getPrimaryColor().field_72449_c);
        }
    }

    @SubscribeEvent
    public static void onAction(GuiScreenEvent.ActionPerformedEvent event) {
        if (event.getButton() instanceof InventoryTabRegeneration) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiPreferences());
        }
    }

    @SubscribeEvent
    public static void onClientUpdate(LivingEvent.LivingUpdateEvent e) {
        if (!(e.getEntity() instanceof EntityPlayer) || Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        EntityPlayer player = (EntityPlayer)e.getEntity();
        UUID clientUUID = Minecraft.func_71410_x().field_71439_g.func_110124_au();
        IRegeneration cap = CapabilityRegeneration.getForPlayer(player);
        Minecraft.func_71410_x().func_152344_a(() -> {
            if (player.field_70173_aa == 50) {
                if (SIDE != null) {
                    SIDE = Minecraft.func_71410_x().field_71474_y.field_186715_A;
                }
                if (cap.areHandsGlowing()) {
                    ClientUtil.playSound(cap.getPlayer(), RegenObjects.Sounds.HAND_GLOW.getRegistryName(), SoundCategory.PLAYERS, true, () -> !cap.areHandsGlowing(), 0.5f);
                }
                if (cap.getState() == PlayerUtil.RegenState.REGENERATING) {
                    ClientUtil.playSound(cap.getPlayer(), RegenObjects.Sounds.REGENERATION_0.getRegistryName(), SoundCategory.PLAYERS, true, () -> !cap.getState().equals((Object)PlayerUtil.RegenState.REGENERATING), 1.0f);
                }
                if (cap.getState().isGraceful() && clientUUID == player.func_110124_au()) {
                    ClientUtil.playSound(cap.getPlayer(), RegenObjects.Sounds.CRITICAL_STAGE.getRegistryName(), SoundCategory.PLAYERS, true, () -> !cap.getState().equals((Object)PlayerUtil.RegenState.GRACE_CRIT), 1.0f);
                    ClientUtil.playSound(cap.getPlayer(), RegenObjects.Sounds.HEART_BEAT.getRegistryName(), SoundCategory.PLAYERS, true, () -> !cap.getState().isGraceful(), 0.2f);
                    ClientUtil.playSound(cap.getPlayer(), RegenObjects.Sounds.GRACE_HUM.getRegistryName(), SoundCategory.AMBIENT, true, () -> cap.getState() != PlayerUtil.RegenState.GRACE, 1.5f);
                }
            }
        });
        if (cap.getAnimationTicks() == 100 && cap.getState() == PlayerUtil.RegenState.REGENERATING && Minecraft.func_71410_x().field_71439_g.func_110124_au().equals(cap.getPlayer().func_110124_au())) {
            SkinChangingHandler.sendSkinUpdate(cap.getPlayer().field_70170_p.field_73012_v, cap.getPlayer());
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public static void onAnimate(ModelRotationEvent ev) {
        if (EnumCompatModids.LCCORE.isLoaded()) {
            return;
        }
        if (ev.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)ev.getEntity();
            IRegeneration data = CapabilityRegeneration.getForPlayer(player);
            AnimationContext context = new AnimationContext(ev.model, player, ev.limbSwing, ev.limbSwingAmount, ev.ageInTicks, ev.netHeadYaw, ev.headPitch);
            if (data.getState() == PlayerUtil.RegenState.REGENERATING) {
                ev.setCanceled(((ATypeRenderer)TypeHandler.getTypeInstance(data.getType()).getRenderer()).onAnimateRegen(context));
            } else {
                AnimationHandler.animate(context);
            }
        }
    }

    @SubscribeEvent
    public static void onRenderGui(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        IRegeneration cap = CapabilityRegeneration.getForPlayer((EntityPlayer)player);
        switch (cap.getState()) {
            case REGENERATING: {
                RenderUtil.renderVignette(cap.getSecondaryColor(), 0.5f, cap.getState());
                if (cap.getAnimationTicks() >= 3) break;
                RegenClientHooks.handleShader();
                break;
            }
            case POST: {
                if (player.field_70737_aN > 0 || player.func_70660_b(MobEffects.field_76431_k) != null) {
                    RenderUtil.renderVignette(cap.getSecondaryColor(), 0.5f, cap.getState());
                }
                if (player.field_70737_aN != 1 && player.field_70173_aa % 600 != 0) break;
                RegenClientHooks.handleShader();
                break;
            }
            case ALIVE: {
                break;
            }
            case GRACE_CRIT: 
            case GRACE: {
                RenderUtil.renderVignette(cap.getSecondaryColor(), 0.5f, cap.getState());
            }
        }
    }

    @SubscribeEvent
    public static void onPlaySound(PlaySoundEvent e) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null || mc.field_71441_e == null) {
            return;
        }
        if (e.getName().equals("entity.generic.explode")) {
            PositionedSoundRecord sound = PositionedSoundRecord.func_194007_a((SoundEvent)SoundEvents.field_187539_bB, (float)1.0f, (float)0.2f);
            mc.field_71441_e.field_73010_i.forEach(arg_0 -> ClientEventHandler.lambda$onPlaySound$6(mc, e, (ISound)sound, arg_0));
            if (CapabilityRegeneration.getForPlayer((EntityPlayer)Minecraft.func_71410_x().field_71439_g).getState() == PlayerUtil.RegenState.REGENERATING) {
                e.setResultSound((ISound)sound);
            }
        }
    }

    @SubscribeEvent
    public static void onSetupFogDensity(EntityViewRenderEvent.FogDensity event) {
        if (Minecraft.func_71410_x().func_175606_aa() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)Minecraft.func_71410_x().func_175606_aa();
            IRegeneration data = CapabilityRegeneration.getForPlayer(player);
            if (data.getState() == PlayerUtil.RegenState.GRACE_CRIT) {
                GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
                event.setCanceled(true);
                float amount = MathHelper.func_76134_b((float)((float)data.getPlayer().field_70173_aa * 0.06f)) * -0.09f;
                event.setDensity(amount);
            }
            if (data.getType() == TypeHandler.RegenType.LAY_FADE && data.getAnimationTicks() > 0) {
                GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
                event.setCanceled(true);
                float opacity = MathHelper.func_76131_a((float)(MathHelper.func_76126_a((float)(((float)player.field_70173_aa + Minecraft.func_71410_x().func_184121_ak()) / 10.0f)) * 0.1f + 0.1f), (float)0.11f, (float)1.0f);
                event.setDensity(opacity);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onClientChatRecieved(ClientChatReceivedEvent e) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (e.getType() != ChatType.CHAT) {
            return;
        }
        if (CapabilityRegeneration.getForPlayer((EntityPlayer)player).getState() != PlayerUtil.RegenState.POST) {
            return;
        }
        if (player.field_70170_p.field_73012_v.nextBoolean()) {
            String[] words;
            String message = e.getMessage().func_150260_c();
            TextComponentString newMessage = new TextComponentString("");
            for (String word : words = message.split(" ")) {
                TextComponentString txtComp;
                if (word.equals(words[0])) {
                    TextComponentString name = new TextComponentString(word + " ");
                    newMessage.func_150257_a((ITextComponent)name);
                    continue;
                }
                if (player.field_70170_p.field_73012_v.nextBoolean()) {
                    txtComp = new TextComponentString(ClientEventHandler.getColoredText("&k" + word + "&r "));
                    txtComp.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString(word)));
                    newMessage.func_150257_a((ITextComponent)txtComp);
                    continue;
                }
                txtComp = new TextComponentString(word + " ");
                newMessage.func_150257_a((ITextComponent)txtComp);
            }
            e.setMessage((ITextComponent)newMessage);
        }
    }

    public static String getColoredText(String msg) {
        return msg.replaceAll("&", String.valueOf('\u00a7'));
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent ev) {
        RegenObjects.ITEMS.forEach(RenderUtil::setItemRender);
        RegenObjects.ITEM_BLOCKS.forEach(RenderUtil::setItemRender);
        RegenObjects.ITEMS = new ArrayList<Item>();
        RegenObjects.ITEM_BLOCKS = new ArrayList<Item>();
    }

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent e) {
        EntityPlayer player;
        if (e.getEntityLiving() instanceof EntityPlayer && (player = (EntityPlayer)e.getEntityLiving()).func_110124_au().equals(Minecraft.func_71410_x().field_71439_g.func_110124_au())) {
            ClientUtil.sendSkinResetPacket();
        }
    }

    @SubscribeEvent
    public static void onRenderHand(RenderHandEvent e) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        float factor = 0.2f;
        if (player.func_184614_ca().func_77973_b() != Items.field_190931_a || mc.field_71474_y.field_74320_O > 0) {
            return;
        }
        IRegeneration cap = CapabilityRegeneration.getForPlayer((EntityPlayer)player);
        boolean flag = cap.getType() == TypeHandler.RegenType.LAY_FADE && cap.getState() == PlayerUtil.RegenState.REGENERATING;
        e.setCanceled(flag);
        if (!cap.areHandsGlowing()) {
            return;
        }
        GlStateManager.func_179094_E();
        float leftHandedFactor = mc.field_71474_y.field_186715_A.equals((Object)EnumHandSide.RIGHT) ? 1.0f : -1.0f;
        GlStateManager.func_179109_b((float)(0.33f * leftHandedFactor), (float)-0.23f, (float)-0.5f);
        GlStateManager.func_179109_b((float)(-0.8f * player.field_70733_aJ * leftHandedFactor), (float)(-0.8f * player.field_70733_aJ), (float)(-0.4f * player.field_70733_aJ));
        GlStateManager.func_179109_b((float)(-(player.field_71154_f - player.field_71163_h) / 400.0f), (float)((player.field_71155_g - player.field_71164_i) / 500.0f), (float)0.0f);
        RenderUtil.setupRenderLightning();
        GlStateManager.func_179114_b((float)(((float)mc.field_71439_g.field_70173_aa + RenderUtil.renderTick) / 2.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        for (int i = 0; i < 15; ++i) {
            GlStateManager.func_179114_b((float)(((float)mc.field_71439_g.field_70173_aa + RenderUtil.renderTick) * (float)i / 70.0f), (float)1.0f, (float)1.0f, (float)0.0f);
            Vec3d primaryColor = cap.getPrimaryColor();
            Random rand = player.field_70170_p.field_73012_v;
            RenderUtil.drawGlowingLine(new Vec3d((double)(-factor / 2.0f + rand.nextFloat() * factor), (double)(-factor / 2.0f + rand.nextFloat() * factor), (double)(-factor / 2.0f + rand.nextFloat() * factor)), new Vec3d((double)(-factor / 2.0f + rand.nextFloat() * factor), (double)(-factor / 2.0f + rand.nextFloat() * factor), (double)(-factor / 2.0f + rand.nextFloat() * factor)), 0.1f, primaryColor, 0.0f);
        }
        RenderUtil.finishRenderLightning();
        GlStateManager.func_179121_F();
    }

    @SubscribeEvent
    public static void onRenderCallBack(RenderCallbackEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            ModelBase model;
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            IRegeneration data = CapabilityRegeneration.getForPlayer(player);
            TypeHandler.RegenType type = data.getType();
            if (data.getState() == PlayerUtil.RegenState.REGENERATING) {
                ((ATypeRenderer)TypeHandler.getTypeInstance(type).getRenderer()).onRenderCallBack(event);
            }
            if (data.getState() == PlayerUtil.RegenState.GRACE_CRIT) {
                GlStateManager.func_179137_b((double)0.0, (double)0.125, (double)0.0);
            }
            if ((model = event.getRenderer().func_177087_b()) instanceof ModelPlayer) {
                ModelPlayer modelPlayer = (ModelPlayer)model;
                if (data.hasDroppedHand()) {
                    if (data.getCutoffHand() == EnumHandSide.RIGHT) {
                        modelPlayer.field_178723_h.field_78807_k = true;
                        modelPlayer.field_178732_b.field_78807_k = true;
                    } else {
                        modelPlayer.field_178723_h.field_78807_k = false;
                        modelPlayer.field_178732_b.field_78807_k = false;
                    }
                    if (data.getCutoffHand() == EnumHandSide.LEFT) {
                        modelPlayer.field_178724_i.field_78807_k = true;
                        modelPlayer.field_178734_a.field_78807_k = true;
                    } else {
                        modelPlayer.field_178724_i.field_78807_k = false;
                        modelPlayer.field_178734_a.field_78807_k = false;
                    }
                } else {
                    modelPlayer.field_178724_i.field_78807_k = false;
                    modelPlayer.field_178734_a.field_78807_k = false;
                    modelPlayer.field_178723_h.field_78807_k = false;
                    modelPlayer.field_178732_b.field_78807_k = false;
                }
            }
        }
    }

    @SubscribeEvent
    public static void onToolTip(ItemTooltipEvent event) {
        if (event.getItemStack().hasCapability(CapabilityArch.CAPABILITY, null)) {
            IArch data = CapabilityArch.getForStack(event.getItemStack());
            DnaHandler.IDna trait = DnaHandler.getDnaEntry(data.getSavedTrait());
            ItemArchInterface.readSync(event.getItemStack());
            if (data.getArchStatus() == IArch.ArchStatus.ARCH_ITEM) {
                event.getToolTip().add(new TextComponentTranslation("regeneration.tooltip.arch_trait", new Object[]{new TextComponentTranslation(trait.getLangKey(), new Object[0]).func_150261_e()}).func_150261_e());
                event.getToolTip().add(new TextComponentTranslation("regeneration.tooltip.stored_regens", new Object[]{data.getRegenAmount()}).func_150261_e());
            }
        }
    }

    @SubscribeEvent
    public static void onRenderGameOverlayPre(RenderGameOverlayEvent.Pre e) {
        IRegeneration data = CapabilityRegeneration.getForPlayer((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (RegenConfig.coolCustomBarThings && data.getRegenerationsLeft() > 0 && data.getState() != PlayerUtil.RegenState.ALIVE && e.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            GlStateManager.func_179094_E();
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_110434_K().func_110577_a(TEX);
            float regensProgress = (float)data.getRegenerationsLeft() / (float)RegenConfig.regenCapacity;
            mc.field_71456_v.func_73729_b(e.getResolution().func_78326_a() / 2 - 91, e.getResolution().func_78328_b() - 86, 0, 0, 182, 5);
            mc.field_71456_v.func_73729_b(e.getResolution().func_78326_a() / 2 - 91, e.getResolution().func_78328_b() - 86, 0, 5, (int)(182.0f * regensProgress), 5);
            mc.field_71456_v.func_73729_b(e.getResolution().func_78326_a() / 2 - 91, 10, 0, 0, 182, 5);
            mc.field_71456_v.func_73729_b(e.getResolution().func_78326_a() / 2 - 91, 10, 0, 5, (int)(182.0f * data.getProgress()), 5);
            String text = data.areHandsGlowing() ? new TextComponentTranslation("transition.regeneration.hand_glow", new Object[0]).func_150261_e() : data.getState().getText().func_150261_e();
            int length = mc.field_71466_p.func_78256_a(text);
            ClientEventHandler.drawStringWithOutline(text, e.getResolution().func_78326_a() / 2 - length / 2, 8, 16761115, 0);
            String regensLeft = String.valueOf(data.getRegenerationsLeft());
            int regensLeftLength = mc.field_71466_p.func_78256_a(regensLeft);
            ClientEventHandler.drawStringWithOutline(regensLeft, e.getResolution().func_78326_a() / 2 - regensLeftLength / 2, e.getResolution().func_78328_b() - 88, 16761115, 0);
            GlStateManager.func_179121_F();
        }
    }

    public static void drawStringWithOutline(String string, int posX, int posY, int fontColor, int outlineColor) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71466_p.func_78276_b(string, posX + 1, posY, outlineColor);
        mc.field_71466_p.func_78276_b(string, posX - 1, posY, outlineColor);
        mc.field_71466_p.func_78276_b(string, posX, posY + 1, outlineColor);
        mc.field_71466_p.func_78276_b(string, posX, posY - 1, outlineColor);
        mc.field_71466_p.func_78276_b(string, posX, posY, fontColor);
    }

    private static /* synthetic */ void lambda$onPlaySound$6(Minecraft mc, PlaySoundEvent e, ISound sound, EntityPlayer player) {
        if (mc.field_71439_g != player && mc.field_71439_g.func_70032_d((Entity)player) < 40.0f && CapabilityRegeneration.getForPlayer(player).getState().equals((Object)PlayerUtil.RegenState.REGENERATING)) {
            e.setResultSound(sound);
        }
    }
}

