/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.client.gui;

import java.awt.Color;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import me.swirtzly.regeneration.RegenerationMod;
import me.swirtzly.regeneration.client.gui.parts.BlankContainer;
import me.swirtzly.regeneration.client.gui.parts.FileButton;
import me.swirtzly.regeneration.client.gui.parts.InventoryTabRegeneration;
import me.swirtzly.regeneration.client.image.ImageDownloadAlt;
import me.swirtzly.regeneration.client.skinhandling.SkinChangingHandler;
import me.swirtzly.regeneration.common.capability.CapabilityRegeneration;
import me.swirtzly.regeneration.network.MessageNextSkin;
import me.swirtzly.regeneration.network.NetworkHandler;
import me.swirtzly.regeneration.util.ClientUtil;
import me.swirtzly.regeneration.util.FileUtil;
import me.swirtzly.regeneration.util.RenderUtil;
import micdoodle8.mods.galacticraft.api.client.tabs.TabRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Mouse;

public class GuiSkinChange
extends GuiContainer {
    public static final int ID = 3;
    private static final ResourceLocation background = new ResourceLocation("regeneration", "textures/gui/customizer_background_small.png");
    public static boolean isAlex = true;
    private static ResourceLocation PLAYER_TEXTURE = Minecraft.func_71410_x().field_71439_g.func_110306_p();
    private static SkinChangingHandler.EnumChoices choices = CapabilityRegeneration.getForPlayer((EntityPlayer)Minecraft.func_71410_x().field_71439_g).getPreferredModel();
    private static List<File> skins = FileUtil.listAllSkins(choices);
    public int posX;
    public int posY;
    private ArrayList<GuiButton> scrollButtonList = new ArrayList();
    private int scrollbarChangeReq;
    private GuiTextField textFieldValue;
    private String skinName = skins.get(0).getName();
    private String skinData = "";
    private GuiButtonExt btnBack;
    private GuiButtonExt btnOpenFolder;
    private GuiButtonExt btnSave;
    private GuiButtonExt btnResetSkin;
    private int scrollbarPosY;
    private int scrollbarIndex;
    private int scrollbarChange;
    private boolean isScrollPressed;

    public GuiSkinChange() {
        super((Container)new BlankContainer());
        this.field_146999_f = 176;
        this.field_147000_g = 186;
        choices = CapabilityRegeneration.getForPlayer((EntityPlayer)Minecraft.func_71410_x().field_71439_g).getPreferredModel();
        skins = FileUtil.listAllSkins(choices);
        if (skins.size() > 0) {
            PLAYER_TEXTURE = SkinChangingHandler.createGuiTexture(skins.get(0));
        } else {
            try {
                throw new Exception("NO SKINS COULD BE FOUND.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void updateModels(File file) {
        try {
            isAlex = ImageDownloadAlt.isAlexSkin(ImageIO.read(file));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void func_73869_a(char eventChar, int eventKey) throws IOException {
        if (this.textFieldValue.func_146201_a(eventChar, eventKey) && !this.textFieldValue.func_146179_b().isEmpty()) {
            this.scrollButtonList.clear();
            for (File skin : FileUtil.similarWords(this.textFieldValue.func_146179_b(), FileUtil.listAllSkins(choices))) {
                FileButton BUTTON = new FileButton(this.scrollButtonList.size() + 3, this.posX + 8, this.posY + 7 + 24 * this.scrollButtonList.size(), skin.getName().replaceAll(".png", ""));
                BUTTON.setFile(skin);
                this.scrollButtonList.add((GuiButton)BUTTON);
                this.updateButtonsList();
            }
        } else {
            if (this.textFieldValue.func_146179_b().isEmpty() && this.textFieldValue.func_146201_a(eventChar, eventKey)) {
                this.scrollButtonList.clear();
                for (File skin : FileUtil.listAllSkins(choices)) {
                    FileButton BUTTON = new FileButton(this.scrollButtonList.size() + 3, this.posX + 8, this.posY + 7 + 24 * this.scrollButtonList.size(), skin.getName().replaceAll(".png", ""));
                    BUTTON.setFile(skin);
                    this.scrollButtonList.add((GuiButton)BUTTON);
                    this.updateButtonsList();
                }
            }
            super.func_73869_a(eventChar, eventKey);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(background);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        GlStateManager.func_179094_E();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(PLAYER_TEXTURE);
        ClientUtil.playerModelAlex.field_78091_s = false;
        ClientUtil.playerModelSteve.field_78091_s = false;
        float rotation = Minecraft.func_71410_x().field_71439_g.field_70173_aa * 2;
        if (isAlex) {
            RenderUtil.drawModelToGui((ModelBase)ClientUtil.playerModelAlex, this.field_146294_l / 2, this.field_146295_m / 2 - 45, 1.0f, rotation);
        } else {
            RenderUtil.drawModelToGui((ModelBase)ClientUtil.playerModelSteve, this.field_146294_l / 2, this.field_146295_m / 2 - 45, 1.0f, rotation);
        }
        GlStateManager.func_179121_F();
        this.func_73732_a(Minecraft.func_71410_x().field_71466_p, new TextComponentTranslation("regeneration.gui.next_incarnation", new Object[0]).func_150260_c(), this.field_146294_l / 2, this.field_146295_m / 2 - 80, Color.WHITE.getRGB());
        this.func_73732_a(Minecraft.func_71410_x().field_71466_p, this.skinName, this.field_146294_l / 2, this.field_146295_m / 2 + 15, Color.WHITE.getRGB());
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.textFieldValue.func_146194_f();
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.textFieldValue.func_146178_a();
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        switch (button.field_146127_k) {
            case 66: {
                Minecraft.func_71410_x().field_71439_g.openGui((Object)RegenerationMod.INSTANCE, 1, (World)Minecraft.func_71410_x().field_71441_e, 0, 0, 0);
                break;
            }
            case 88: {
                NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageNextSkin(this.skinData, isAlex));
                break;
            }
            case 100: {
                ClientUtil.sendSkinResetPacket();
                break;
            }
            case 77: {
                try {
                    Desktop.getDesktop().open(SkinChangingHandler.SKIN_DIRECTORY);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                Minecraft.func_71410_x().func_147108_a(null);
            }
        }
        if (button instanceof FileButton) {
            FileButton buttonUpdate = (FileButton)button;
            PLAYER_TEXTURE = SkinChangingHandler.createGuiTexture(buttonUpdate.getFile());
            GuiSkinChange.updateModels(buttonUpdate.getFile());
            this.skinName = buttonUpdate.getFile().getName().substring(0, 1).toUpperCase() + buttonUpdate.getFile().getName().substring(1).replaceAll(".png", "");
            this.btnSave.field_146124_l = true;
            this.skinData = SkinChangingHandler.imageToPixelData(buttonUpdate.getFile());
        }
    }

    public void func_73866_w_() {
        int cx = (this.field_146294_l - this.field_146999_f) / 2;
        int cy = (this.field_146295_m - this.field_147000_g) / 2;
        this.scrollButtonList.clear();
        for (File skin : skins) {
            FileButton BUTTON = new FileButton(this.scrollButtonList.size() + 3, this.posX + 8, this.posY + 7 + 24 * this.scrollButtonList.size(), skin.getName().replaceAll(".png", ""));
            BUTTON.setFile(skin);
            this.scrollButtonList.add((GuiButton)BUTTON);
        }
        this.textFieldValue = new GuiTextField(10, this.field_146297_k.field_71466_p, cx - 220, cy + 15, 200, 20);
        this.textFieldValue.func_146203_f(10000);
        this.textFieldValue.func_146180_a("");
        this.textFieldValue.func_146184_c(true);
        this.textFieldValue.func_146195_b(true);
        this.textFieldValue.func_146185_a(true);
        super.func_73866_w_();
        TabRegistry.updateTabValues(this.field_147003_i, this.field_147009_r, InventoryTabRegeneration.class);
        TabRegistry.addTabsToList(this.field_146292_n);
        int btnW = 68;
        int btnH = 17;
        this.btnBack = new GuiButtonExt(66, cx + 20, cy + 145, 68, 17, new TextComponentTranslation("regeneration.gui.back", new Object[0]).func_150254_d());
        this.btnOpenFolder = new GuiButtonExt(77, cx + 90, cy + 145, 68, 17, new TextComponentTranslation("regeneration.gui.open_folder", new Object[0]).func_150254_d());
        this.btnSave = new GuiButtonExt(88, cx + 90, cy + 127, 68, 17, new TextComponentTranslation("regeneration.gui.save", new Object[0]).func_150254_d());
        this.btnResetSkin = new GuiButtonExt(100, cx + 20, cy + 127, 68, 17, new TextComponentTranslation("regeneration.gui.reset_skin", new Object[0]).func_150254_d());
        this.btnSave.field_146124_l = false;
        this.skinName = this.skinName.substring(0, 1).toUpperCase() + this.skinName.substring(1).replaceAll(".png", "");
        this.updateButtonsList();
    }

    public boolean needsScrollbar() {
        return this.scrollButtonList.size() > 8;
    }

    public void updateButtonsList() {
        this.field_146292_n.clear();
        this.func_189646_b((GuiButton)this.btnOpenFolder);
        this.func_189646_b((GuiButton)this.btnBack);
        this.func_189646_b((GuiButton)this.btnSave);
        this.func_189646_b((GuiButton)this.btnResetSkin);
        int id = 1000;
        int cx = (this.field_146294_l - this.field_146999_f) / 2;
        int cy = (this.field_146295_m - this.field_147000_g) / 2;
        for (int i = this.scrollbarIndex; i < this.scrollbarIndex + 5 && i < this.scrollButtonList.size(); ++i) {
            FileButton but = (FileButton)this.scrollButtonList.get(i);
            FileButton BUTTON = new FileButton(id, cx - 220, cy + 45 + 24 * (i - this.scrollbarIndex), but.field_146126_j);
            BUTTON.setFile(but.getFile());
            this.field_146292_n.add(BUTTON);
            ++id;
        }
    }

    public void updateScrollPositon(int change) {
        if (change != 0 && this.needsScrollbar()) {
            this.scrollbarPosY = change;
            if (this.scrollbarPosY > 85) {
                this.scrollbarPosY = 85;
            }
            if (this.scrollbarPosY < 0) {
                this.scrollbarPosY = 0;
            }
            this.updateScrollIndex();
        }
    }

    public void updateScrollIndex() {
        if (this.scrollbarPosY <= this.scrollbarChangeReq) {
            this.scrollbarIndex = 0;
            this.scrollbarChange = this.scrollbarPosY;
            this.updateButtonsList();
        } else if (this.scrollbarPosY - this.scrollbarChange >= this.scrollbarChangeReq) {
            ++this.scrollbarIndex;
            this.scrollbarChange = this.scrollbarPosY;
            this.updateButtonsList();
        } else if (this.scrollbarPosY - this.scrollbarChange <= -1 * this.scrollbarChangeReq) {
            --this.scrollbarIndex;
            this.scrollbarChange = this.scrollbarPosY;
            if (this.scrollbarIndex < 0) {
                this.scrollbarIndex = 0;
            }
            this.updateButtonsList();
        }
    }

    private boolean isMouseOverArea(int mouseX, int mouseY, int posX, int posY, int width, int height) {
        return mouseX >= posX && mouseX < posX + width && mouseY >= posY && mouseY < posY + height;
    }

    public void func_146274_d() {
        try {
            super.func_146274_d();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int wheelState = Mouse.getEventDWheel();
        if (wheelState != 0) {
            this.updateScrollPositon(this.scrollbarPosY - wheelState / 10);
        }
    }

    public void func_73864_a(int mouseX, int mouseY, int button) {
        this.textFieldValue.func_146192_a(mouseX, mouseY, button);
        try {
            super.func_73864_a(mouseX, mouseY, button);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int posX = (this.field_146294_l - this.field_146999_f) / 2;
        int posY = (this.field_146295_m - this.field_147000_g) / 2;
        if (button != 0 || !this.needsScrollbar()) {
            return;
        }
        if (this.isMouseOverArea(mouseX, mouseY, posX + 154, posY + 7 + this.scrollbarPosY, 12, 15)) {
            this.isScrollPressed = true;
        }
    }

    public void func_146273_a(int mouseX, int mouseY, int button, long timeSince) {
        super.func_146273_a(mouseX, mouseY, button, timeSince);
        int posX = (this.field_146294_l - this.field_146999_f) / 2;
        int posY = (this.field_146295_m - this.field_147000_g) / 2;
        if (Mouse.isButtonDown((int)0) && this.isScrollPressed) {
            this.updateScrollPositon(mouseY - posY);
            if (!Mouse.isButtonDown((int)0)) {
                this.isScrollPressed = false;
            }
        }
    }
}

