/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.client.rendering.layers;

import me.swirtzly.regeneration.client.rendering.layers.LayerRegeneration;
import me.swirtzly.regeneration.client.rendering.types.ATypeRenderer;
import me.swirtzly.regeneration.client.rendering.types.TypeFieryRenderer;
import me.swirtzly.regeneration.common.capability.CapabilityRegeneration;
import me.swirtzly.regeneration.common.capability.IRegeneration;
import me.swirtzly.regeneration.common.types.TypeHandler;
import me.swirtzly.regeneration.util.PlayerUtil;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHandSide;

public class LayerHands
implements LayerRenderer<EntityPlayer> {
    protected final RenderLivingBase<?> livingEntityRenderer;

    public LayerHands(RenderLivingBase<?> livingEntityRendererIn) {
        this.livingEntityRenderer = livingEntityRendererIn;
    }

    public void doRenderLayer(EntityPlayer entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        GlStateManager.func_179094_E();
        IRegeneration data = CapabilityRegeneration.getForPlayer(entitylivingbaseIn);
        if (this.livingEntityRenderer.func_177087_b().field_78091_s) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.75f, (float)0.0f);
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        }
        if (data.areHandsGlowing()) {
            this.renderHand(entitylivingbaseIn, EnumHandSide.LEFT, EnumHandRenderType.GRACE);
            this.renderHand(entitylivingbaseIn, EnumHandSide.RIGHT, EnumHandRenderType.GRACE);
        }
        if (data.getState() == PlayerUtil.RegenState.REGENERATING) {
            this.renderHand(entitylivingbaseIn, EnumHandSide.LEFT, EnumHandRenderType.REGEN);
            this.renderHand(entitylivingbaseIn, EnumHandSide.RIGHT, EnumHandRenderType.REGEN);
        }
        if (data.isSyncingToJar()) {
            this.renderHand(entitylivingbaseIn, EnumHandSide.LEFT, EnumHandRenderType.JAR);
            this.renderHand(entitylivingbaseIn, EnumHandSide.RIGHT, EnumHandRenderType.JAR);
        }
        GlStateManager.func_179121_F();
    }

    public void renderHand(EntityPlayer player, EnumHandSide handSide, EnumHandRenderType type) {
        GlStateManager.func_179094_E();
        IRegeneration data = CapabilityRegeneration.getForPlayer(player);
        if (player.func_70093_af()) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
        }
        this.translateToHand(handSide);
        boolean flag = handSide == EnumHandSide.LEFT;
        GlStateManager.func_179109_b((float)((float)(flag ? -1 : 1) / 25.0f), (float)0.125f, (float)-0.625f);
        GlStateManager.func_179137_b((double)0.0, (double)-0.05, (double)0.6);
        if (type == EnumHandRenderType.GRACE) {
            LayerRegeneration.renderGlowingHands(player, data, 1.5f);
        }
        if (type == EnumHandRenderType.REGEN) {
            ((ATypeRenderer)TypeHandler.getTypeInstance(data.getType()).getRenderer()).renderHand(player, handSide, this.livingEntityRenderer);
        }
        if (type == EnumHandRenderType.JAR) {
            TypeFieryRenderer.renderConeAtArms(player);
        }
        GlStateManager.func_179121_F();
    }

    protected void translateToHand(EnumHandSide handSide) {
        ((ModelBiped)this.livingEntityRenderer.func_177087_b()).func_187073_a(0.0625f, handSide);
    }

    public boolean func_177142_b() {
        return false;
    }

    public static enum EnumHandRenderType {
        REGEN,
        GRACE,
        JAR;

    }
}

