/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.client.rendering.tile;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import me.swirtzly.regeneration.client.models.ModelHand;
import me.swirtzly.regeneration.client.rendering.types.TypeFieryRenderer;
import me.swirtzly.regeneration.client.skinhandling.SkinChangingHandler;
import me.swirtzly.regeneration.common.item.ItemHand;
import me.swirtzly.regeneration.common.tiles.TileEntityHandInJar;
import me.swirtzly.regeneration.handlers.RegenObjects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;

public class RenderTileEntityHand
extends TileEntitySpecialRenderer<TileEntityHandInJar> {
    private static final ResourceLocation TEXTURE_STEVE = new ResourceLocation("textures/entity/steve.png");
    private static final ResourceLocation TEXTURE_ALEX = new ResourceLocation("textures/entity/alex.png");
    public static HashMap<TileEntityHandInJar, ResourceLocation> TEXTURES = new HashMap();
    public static ModelBase STEVE_ARM = new ModelHand(false);
    public static ModelBase ALEX_ARM = new ModelHand(true);

    public void render(TileEntityHandInJar te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        if (te.getHand().func_77973_b() == RegenObjects.Items.HAND) {
            String handType = ItemHand.getSkinType(te.getHand());
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.getOrCreateTexture(te));
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)0.5, (double)-1.5, (double)-0.5);
            if (handType.equals("ALEX")) {
                ALEX_ARM.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
                if (te.getLindosAmont() >= 100) {
                    TypeFieryRenderer.renderOverlay((EntityPlayer)Minecraft.func_71410_x().field_71439_g, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f, ALEX_ARM);
                }
            } else {
                STEVE_ARM.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
                if (te.getLindosAmont() >= 100) {
                    TypeFieryRenderer.renderOverlay((EntityPlayer)Minecraft.func_71410_x().field_71439_g, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f, STEVE_ARM);
                }
            }
        } else {
            TEXTURES.remove((Object)te);
        }
        GlStateManager.func_179121_F();
    }

    public ResourceLocation getOrCreateTexture(TileEntityHandInJar tileEntityHandInJar) {
        String skinString = ItemHand.getTextureString(tileEntityHandInJar.getHand());
        if (skinString.equalsIgnoreCase("NONE") || skinString.equals(" ") || skinString.equals("")) {
            boolean isAlex = ItemHand.getSkinType(tileEntityHandInJar.getHand()).equalsIgnoreCase("ALEX");
            return isAlex ? TEXTURE_ALEX : TEXTURE_STEVE;
        }
        if (!TEXTURES.containsKey((Object)tileEntityHandInJar)) {
            try {
                BufferedImage image = SkinChangingHandler.toImage(ItemHand.getTextureString(tileEntityHandInJar.getHand()));
                ResourceLocation res = Minecraft.func_71410_x().func_110434_K().func_110578_a("hand_", new DynamicTexture(image));
                TEXTURES.put(tileEntityHandInJar, res);
                return res;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return TEXTURES.get((Object)tileEntityHandInJar);
    }
}

