/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.client.skinhandling;

import java.util.HashMap;
import java.util.UUID;
import me.swirtzly.regeneration.RegenerationMod;
import me.swirtzly.regeneration.client.skinhandling.SkinInfo;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class PlayerDataPool {
    private static HashMap<UUID, SkinInfo> PLAYER_POOL = new HashMap();

    public static void addPlayer(EntityPlayer player, SkinInfo info) {
        info.setUpdateRequired(true);
        PLAYER_POOL.put(player.func_110124_au(), info);
    }

    public static void addPlayer(UUID player, SkinInfo info) {
        info.setUpdateRequired(true);
        PLAYER_POOL.put(player, info);
    }

    public static void removePlayer(EntityPlayer player) {
        if (PLAYER_POOL.containsKey(player.func_110124_au())) {
            PLAYER_POOL.remove(player.func_110124_au()).setUpdateRequired(true);
        }
    }

    public static void updatePlayer(EntityPlayer player, SkinInfo info) {
        if (PLAYER_POOL.containsKey(player.func_110124_au())) {
            PLAYER_POOL.replace(player.func_110124_au(), info);
        } else {
            PlayerDataPool.addPlayer(player, info);
        }
    }

    public static void removePlayer(UUID player) {
        if (PLAYER_POOL.containsKey(player)) {
            PLAYER_POOL.get(player).setUpdateRequired(true);
        }
    }

    public static SkinInfo get(AbstractClientPlayer player) {
        if (PLAYER_POOL.containsKey(player.func_110124_au())) {
            return PLAYER_POOL.get(player.func_110124_au());
        }
        return new SkinInfo().setUpdateRequired(true);
    }

    public static void wipeAllData() {
        if (!PLAYER_POOL.isEmpty()) {
            PLAYER_POOL.clear();
            RegenerationMod.LOG.info("Cleared Player Pool.");
        }
    }
}

