/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.client.skinhandling;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.imageio.ImageIO;
import me.swirtzly.regeneration.RegenConfig;
import me.swirtzly.regeneration.RegenerationMod;
import me.swirtzly.regeneration.client.image.ImageBufferDownloadAlt;
import me.swirtzly.regeneration.client.image.ImageDownloadAlt;
import me.swirtzly.regeneration.client.rendering.types.ATypeRenderer;
import me.swirtzly.regeneration.client.skinhandling.PlayerDataPool;
import me.swirtzly.regeneration.client.skinhandling.SkinInfo;
import me.swirtzly.regeneration.common.capability.CapabilityRegeneration;
import me.swirtzly.regeneration.common.capability.IRegeneration;
import me.swirtzly.regeneration.common.types.IRegenType;
import me.swirtzly.regeneration.common.types.TypeHandler;
import me.swirtzly.regeneration.network.MessageUpdateSkin;
import me.swirtzly.regeneration.network.NetworkHandler;
import me.swirtzly.regeneration.util.ClientUtil;
import me.swirtzly.regeneration.util.FileUtil;
import me.swirtzly.regeneration.util.PlayerUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class SkinChangingHandler {
    public static final File SKIN_DIRECTORY = new File(RegenConfig.skins.skinDir + "/Regeneration/skins/");
    public static final File SKIN_DIRECTORY_STEVE = new File(SKIN_DIRECTORY, "/steve");
    public static final File SKIN_DIRECTORY_ALEX = new File(SKIN_DIRECTORY, "/alex");
    public static final Logger SKIN_LOG = LogManager.getLogger((String)"Regeneration Skin Handler");
    private static final Random RAND = new Random();

    public static String imageToPixelData(File imageFile) throws IOException {
        byte[] imageBytes = IOUtils.toByteArray((InputStream)new FileInputStream(imageFile));
        return Base64.getEncoder().encodeToString(imageBytes);
    }

    public static BufferedImage toImage(String imageString) throws IOException {
        BufferedImage image = null;
        Base64.Decoder decoder = Base64.getDecoder();
        byte[] imageByte = decoder.decode(imageString);
        ByteArrayInputStream bis = new ByteArrayInputStream(imageByte);
        image = ImageIO.read(bis);
        bis.close();
        if (image == null) {
            throw new IllegalStateException("The image data was " + imageString + " but the image became null...");
        }
        return image;
    }

    public static void sendSkinUpdate(Random random, EntityPlayer player) {
        if (Minecraft.func_71410_x().field_71439_g.func_110124_au() != player.func_110124_au()) {
            return;
        }
        IRegeneration cap = CapabilityRegeneration.getForPlayer(player);
        if (RegenConfig.skins.changeMySkin) {
            String pixelData = "NONE";
            File skin = null;
            if (cap.getNextSkin().equals("NONE")) {
                boolean isAlex = cap.getPreferredModel().isAlex();
                skin = SkinChangingHandler.getRandomSkin(random, isAlex);
                RegenerationMod.LOG.info(skin + " was choosen");
                try {
                    pixelData = SkinChangingHandler.imageToPixelData(skin);
                    NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageUpdateSkin(pixelData, isAlex));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                pixelData = cap.getNextSkin();
                NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageUpdateSkin(pixelData, cap.getNextSkinType() == SkinInfo.SkinType.ALEX));
            }
        } else {
            ClientUtil.sendSkinResetPacket();
        }
    }

    private static File getRandomSkin(Random rand, boolean isAlex) {
        List<File> skins = FileUtil.listAllSkins(isAlex ? EnumChoices.ALEX : EnumChoices.STEVE);
        if (skins.isEmpty()) {
            FileUtil.doSetupOnThread();
            skins = FileUtil.listAllSkins(isAlex ? EnumChoices.ALEX : EnumChoices.STEVE);
        }
        for (File skin : skins) {
            if (skin.getName().contains(".png")) continue;
            skins.remove(skin);
        }
        SKIN_LOG.info("There were " + skins.size() + " skins to chose from");
        return (File)skins.toArray()[rand.nextInt(skins.size())];
    }

    public static SkinInfo update(AbstractClientPlayer player) {
        boolean shouldBeMojang;
        IRegeneration data = CapabilityRegeneration.getForPlayer((EntityPlayer)player);
        SkinInfo skinData = PlayerDataPool.get(player);
        boolean bl = shouldBeMojang = data.getEncodedSkin().toLowerCase().equals("none") || data.getEncodedSkin().equals(" ") || data.getEncodedSkin().equals("");
        if (shouldBeMojang) {
            SkinChangingHandler.setPlayerSkin(player, null);
            skinData.setTextureLocation(SkinChangingHandler.getMojangSkin(player));
        } else {
            BufferedImage bufferedImage = null;
            try {
                bufferedImage = SkinChangingHandler.toImage(data.getEncodedSkin());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            bufferedImage = ClientUtil.ImageFixer.convertSkinTo64x64(bufferedImage);
            if (bufferedImage != null) {
                DynamicTexture tex = new DynamicTexture(bufferedImage);
                ResourceLocation location = Minecraft.func_71410_x().func_110434_K().func_110578_a(player.func_70005_c_().toLowerCase() + "_skin_" + System.currentTimeMillis(), tex);
                RegenerationMod.LOG.warn("Generating Skin file for " + player.func_70005_c_() + " || " + location);
                skinData.setTextureLocation(location);
            }
        }
        SkinInfo newData = skinData.setSkintype(SkinChangingHandler.getSkinType((EntityPlayer)player, false)).setUpdateRequired(false);
        PlayerDataPool.updatePlayer((EntityPlayer)player, newData);
        return newData;
    }

    public static ResourceLocation createGuiTexture(File file) {
        BufferedImage bufferedImage = null;
        try {
            if (file == null) {
                return DefaultPlayerSkin.func_177335_a();
            }
            bufferedImage = ImageIO.read(file);
            if (bufferedImage != null) {
                return Minecraft.func_71410_x().func_110434_K().func_110578_a("gui_skin_" + System.currentTimeMillis(), new DynamicTexture(bufferedImage));
            }
            return DefaultPlayerSkin.func_177335_a();
        }
        catch (IOException e) {
            e.printStackTrace();
            return DefaultPlayerSkin.func_177335_a();
        }
    }

    private static ResourceLocation getMojangSkin(AbstractClientPlayer player) {
        Map map = Minecraft.func_71410_x().func_152342_ad().func_152788_a(player.func_146103_bH());
        if (map.isEmpty()) {
            map = Minecraft.func_71410_x().func_152347_ac().getTextures(Minecraft.func_71410_x().func_152347_ac().fillProfileProperties(player.func_146103_bH(), false), false);
        }
        if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
            MinecraftProfileTexture profile = (MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN);
            File dir = new File((File)ObfuscationReflectionHelper.getPrivateValue(SkinManager.class, (Object)Minecraft.func_71410_x().func_152342_ad(), (int)2), profile.getHash().substring(0, 2));
            File file = new File(dir, profile.getHash());
            if (file.exists()) {
                file.delete();
            }
            ResourceLocation location = new ResourceLocation("skins/" + profile.getHash());
            SkinChangingHandler.loadTexture(file, location, DefaultPlayerSkin.func_177335_a(), profile.getUrl(), player);
            SkinChangingHandler.setPlayerSkin(player, location);
            return player.func_110306_p();
        }
        return DefaultPlayerSkin.func_177335_a();
    }

    private static ITextureObject loadTexture(File file, ResourceLocation resource, ResourceLocation def, String par1Str, AbstractClientPlayer player) {
        TextureManager texturemanager = Minecraft.func_71410_x().func_110434_K();
        Object object = texturemanager.func_110581_b(resource);
        if (object == null) {
            object = new ImageDownloadAlt(file, par1Str, def, (IImageBuffer)new ImageBufferDownloadAlt(true));
            texturemanager.func_110579_a(resource, object);
        }
        return object;
    }

    public static void setPlayerSkin(AbstractClientPlayer player, ResourceLocation texture) {
        if (player.func_110306_p() == texture) {
            return;
        }
        NetworkPlayerInfo playerInfo = player.field_175157_a;
        if (playerInfo == null) {
            return;
        }
        Map playerTextures = playerInfo.field_187107_a;
        playerTextures.put(MinecraftProfileTexture.Type.SKIN, texture);
        if (texture == null) {
            playerInfo.field_178864_d = false;
        }
    }

    public static void setSkinType(AbstractClientPlayer player, SkinInfo.SkinType skinType) {
        NetworkPlayerInfo playerInfo = player.field_175157_a;
        if (playerInfo != null) {
            playerInfo.field_178863_g = skinType.getMojangType();
        }
    }

    public static SkinInfo.SkinType getSkinType(EntityPlayer player, boolean forceMojang) {
        Map map = Minecraft.func_71410_x().func_152342_ad().func_152788_a(player.func_146103_bH());
        if (map.isEmpty()) {
            map = Minecraft.func_71410_x().func_152347_ac().getTextures(Minecraft.func_71410_x().func_152347_ac().fillProfileProperties(player.func_146103_bH(), false), false);
        }
        MinecraftProfileTexture profile = (MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN);
        IRegeneration data = CapabilityRegeneration.getForPlayer(player);
        if (data.getEncodedSkin().toLowerCase().equals("none") || forceMojang) {
            if (profile == null) {
                return SkinInfo.SkinType.STEVE;
            }
            if (profile.getMetadata("model") == null) {
                return SkinInfo.SkinType.STEVE;
            }
        } else {
            return data.getSkinType();
        }
        return SkinInfo.SkinType.ALEX;
    }

    @SubscribeEvent
    public void onRenderPlayer(RenderPlayerEvent.Post e) {
        AbstractClientPlayer player = (AbstractClientPlayer)e.getEntityPlayer();
        IRegeneration cap = CapabilityRegeneration.getForPlayer((EntityPlayer)player);
        IRegenType type = TypeHandler.getTypeInstance(cap.getType());
        if (cap.getState() == PlayerUtil.RegenState.REGENERATING) {
            ((ATypeRenderer)type.getRenderer()).onRenderRegeneratingPlayerPost(type, e, cap);
        }
    }

    @SubscribeEvent
    public void clickTick(TickEvent.ClientTickEvent e) {
        if (Minecraft.func_71410_x().field_71441_e == null) {
            PlayerDataPool.wipeAllData();
        }
    }

    @SubscribeEvent
    public void onRenderPlayer(RenderPlayerEvent.Pre e) {
        if (MinecraftForgeClient.getRenderPass() == -1) {
            return;
        }
        AbstractClientPlayer player = (AbstractClientPlayer)e.getEntityPlayer();
        IRegeneration cap = CapabilityRegeneration.getForPlayer((EntityPlayer)player);
        IRegenType type = TypeHandler.getTypeInstance(cap.getType());
        SkinInfo skinData = PlayerDataPool.get(player);
        if (skinData == null) {
            skinData = SkinChangingHandler.update(player);
            PlayerDataPool.addPlayer((EntityPlayer)player, skinData);
        }
        if (player.field_70173_aa < 20 || skinData.isUpdateRequired()) {
            SkinChangingHandler.update(player);
        }
        SkinChangingHandler.setPlayerSkin(player, skinData.getTextureLocation());
        SkinChangingHandler.setSkinType(player, skinData.getSkintype());
        if (cap.getState() == PlayerUtil.RegenState.REGENERATING) {
            if (type.getAnimationProgress(cap) > 0.7) {
                // empty if block
            }
            ((ATypeRenderer)type.getRenderer()).onRenderRegeneratingPlayerPre(type, e, cap);
        }
    }

    public static enum EnumChoices implements FileUtil.IEnum
    {
        ALEX(true),
        STEVE(false),
        EITHER(true);

        private boolean isAlex;

        private EnumChoices(boolean b) {
            this.isAlex = b;
        }

        public boolean isAlex() {
            if (this == EITHER) {
                return RAND.nextBoolean();
            }
            return this.isAlex;
        }
    }
}

