/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.common;

import me.swirtzly.regeneration.RegenerationMod;
import me.swirtzly.regeneration.compat.lucraft.PlayerCanRegenEvent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;

@Mod.EventBusSubscriber
public class RegenPermission {
    public static String CAN_REGENERATE = RegenPermission.createPerm("can.regenerate");

    public static void registerPermissions() {
        PermissionAPI.registerNode((String)CAN_REGENERATE, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"This permission determines whether someone can Regenerate");
    }

    public static String createPerm(String perm) {
        String permission = "regeneration." + perm;
        RegenerationMod.LOG.info("Registered Permission: " + permission);
        return permission;
    }

    public static boolean isAllowedToRegeneration(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        return PermissionAPI.hasPermission((EntityPlayer)player, (String)CAN_REGENERATE);
    }

    @SubscribeEvent
    public static void onRegenerate(PlayerCanRegenEvent event) {
        if (!RegenPermission.isAllowedToRegeneration(event.getEntityPlayer())) {
            event.setCanceled(true);
        }
    }
}

