/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.common.block;

import javax.annotation.Nullable;
import me.swirtzly.regeneration.RegenerationMod;
import me.swirtzly.regeneration.common.capability.CapabilityRegeneration;
import me.swirtzly.regeneration.common.capability.IRegeneration;
import me.swirtzly.regeneration.common.entity.EntityLindos;
import me.swirtzly.regeneration.common.tiles.TileEntityHandInJar;
import me.swirtzly.regeneration.handlers.RegenObjects;
import me.swirtzly.regeneration.util.PlayerUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockHandInJar
extends BlockDirectional {
    public BlockHandInJar() {
        super(Material.field_151572_C);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176387_N, (Comparable)EnumFacing.SOUTH));
        this.func_149711_c(5.0f);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return false;
        }
        if (worldIn.func_175625_s(pos) instanceof TileEntityHandInJar) {
            TileEntityHandInJar jar = (TileEntityHandInJar)worldIn.func_175625_s(pos);
            IRegeneration data = CapabilityRegeneration.getForPlayer(playerIn);
            if (jar.getLindosAmont() >= 100 && data.getState() == PlayerUtil.RegenState.ALIVE && playerIn.func_70093_af() && jar.hasHand()) {
                jar.setLindosAmont(jar.getLindosAmont() - 100);
                data.receiveRegenerations(1);
                data.setSyncingFromJar(true);
                worldIn.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), RegenObjects.Sounds.HAND_GLOW, SoundCategory.PLAYERS, 1.0f, 0.7f);
                data.synchronise();
                jar.sendUpdates();
                return true;
            }
            if (data.getState() != PlayerUtil.RegenState.REGENERATING && !playerIn.func_70093_af()) {
                playerIn.openGui((Object)RegenerationMod.INSTANCE, 77, worldIn, jar.func_174877_v().func_177958_n(), jar.func_174877_v().func_177956_o(), jar.func_174877_v().func_177952_p());
                return true;
            }
        }
        return false;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityHandInJar();
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176387_N});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)field_176387_N)).func_176745_a();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)field_176387_N, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)field_176387_N)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)field_176387_N)));
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)field_176387_N, (Comparable)enumfacing);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (world.field_72995_K) {
            return super.removedByPlayer(state, world, pos, player, willHarvest);
        }
        if (world.func_175625_s(pos) instanceof TileEntityHandInJar) {
            TileEntityHandInJar jar = (TileEntityHandInJar)world.func_175625_s(pos);
            if (jar != null && jar.lindosAmont > 0) {
                EntityLindos lindos = new EntityLindos(player.field_70170_p);
                lindos.func_70012_b(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v, 0.0f, 0.0f);
                lindos.setAmount(jar.lindosAmont);
                player.field_70170_p.func_72838_d((Entity)lindos);
            }
            if (jar != null) {
                InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)jar);
            }
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public CreativeTabs func_149708_J() {
        return CreativeTabs.field_78026_f;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        EnumFacing entityFacing = entity.func_174811_aO();
        if (!world.field_72995_K) {
            if (entityFacing == EnumFacing.NORTH) {
                entityFacing = EnumFacing.SOUTH;
            } else if (entityFacing == EnumFacing.EAST) {
                entityFacing = EnumFacing.WEST;
            } else if (entityFacing == EnumFacing.SOUTH) {
                entityFacing = EnumFacing.NORTH;
            } else if (entityFacing == EnumFacing.WEST) {
                entityFacing = EnumFacing.EAST;
            }
            world.func_180501_a(pos, state.func_177226_a((IProperty)field_176387_N, (Comparable)entityFacing), 2);
        }
    }
}

