/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.common.capability;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import me.swirtzly.regeneration.RegenConfig;
import me.swirtzly.regeneration.RegenerationMod;
import me.swirtzly.regeneration.client.skinhandling.SkinChangingHandler;
import me.swirtzly.regeneration.client.skinhandling.SkinInfo;
import me.swirtzly.regeneration.common.advancements.RegenTriggers;
import me.swirtzly.regeneration.common.block.BlockHandInJar;
import me.swirtzly.regeneration.common.capability.IRegeneration;
import me.swirtzly.regeneration.common.capability.IRegenerationStateManager;
import me.swirtzly.regeneration.common.tiles.TileEntityHandInJar;
import me.swirtzly.regeneration.common.traits.DnaHandler;
import me.swirtzly.regeneration.common.types.TypeHandler;
import me.swirtzly.regeneration.handlers.ActingForwarder;
import me.swirtzly.regeneration.handlers.RegenObjects;
import me.swirtzly.regeneration.network.MessageSynchronisationRequest;
import me.swirtzly.regeneration.network.MessageSynchroniseRegeneration;
import me.swirtzly.regeneration.network.NetworkHandler;
import me.swirtzly.regeneration.util.DebuggableScheduledAction;
import me.swirtzly.regeneration.util.PlayerUtil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.tuple.Pair;

public class CapabilityRegeneration
implements IRegeneration {
    @CapabilityInject(value=IRegeneration.class)
    public static final Capability<IRegeneration> CAPABILITY = null;
    public static final ResourceLocation CAP_REGEN_ID = new ResourceLocation("regeneration", "regeneration");
    private final EntityPlayer player;
    private final RegenerationStateManager stateManager;
    public int regenerationsLeft;
    public int ticksAnimating = 0;
    private boolean didSetup = false;
    private boolean traitActive = true;
    private boolean syncingToJar = false;
    private boolean handDropped = false;
    private PlayerUtil.RegenState state = PlayerUtil.RegenState.ALIVE;
    private TypeHandler.RegenType regenType = TypeHandler.RegenType.FIERY;
    private String BASE64_SKIN = "NONE";
    private String BASE64_SKIN_NEXT = "NONE";
    private String deathSource = "";
    private SkinChangingHandler.EnumChoices preferredModel = SkinChangingHandler.EnumChoices.EITHER;
    private float primaryRed = 0.93f;
    private float primaryGreen = 0.61f;
    private float primaryBlue = 0.0f;
    private float secondaryRed = 1.0f;
    private float secondaryGreen = 0.5f;
    private float secondaryBlue = 0.18f;
    private ResourceLocation traitLocation = new ResourceLocation("regeneration", "boring");
    private SkinInfo.SkinType nextSkinType = SkinInfo.SkinType.ALEX;
    private SkinInfo.SkinType skinType = SkinInfo.SkinType.ALEX;
    private EnumHandSide cutOffHand = EnumHandSide.LEFT;
    private boolean handsAreGlowingClient;
    private float progress = 0.0f;

    public CapabilityRegeneration() {
        this.player = null;
        this.stateManager = null;
    }

    public CapabilityRegeneration(EntityPlayer player) {
        this.player = player;
        this.stateManager = !player.field_70170_p.field_72995_K ? new RegenerationStateManager() : null;
    }

    @Nonnull
    public static IRegeneration getForPlayer(EntityPlayer player) {
        if (player.hasCapability(CAPABILITY, null)) {
            return (IRegeneration)player.getCapability(CAPABILITY, null);
        }
        throw new IllegalStateException("Missing Regeneration capability: " + player + ", please report this to the issue tracker");
    }

    @Override
    public void tick() {
        if (!this.didSetup && this.player.field_70170_p.field_72995_K) {
            NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageSynchronisationRequest(this.player));
            this.didSetup = true;
        }
        if (!this.player.field_70170_p.field_72995_K) {
            if (!RegenConfig.onRegen.traitsEnabled) {
                DnaHandler.getDnaEntry(this.getDnaType()).onRemoved(this);
                this.setDnaType(DnaHandler.DNA_BORING.resourceLocation);
            }
            if (this.stateManager != null && this.state != PlayerUtil.RegenState.ALIVE) {
                if (!this.areHandsGlowing()) {
                    this.setProgress((float)this.stateManager.getStateProgress());
                } else {
                    this.setProgress((float)this.stateManager.handGlowTimer.getProgress());
                }
            }
            if (this.isSyncingToJar() && this.ticksAnimating >= 250) {
                this.setSyncingFromJar(false);
                this.ticksAnimating = 0;
                this.synchronise();
            } else if (this.isSyncingToJar()) {
                PlayerUtil.setPerspective((EntityPlayerMP)this.player, true, false);
            }
        }
        this.ticksAnimating = this.state != PlayerUtil.RegenState.REGENERATING && !this.isSyncingToJar() ? 0 : ++this.ticksAnimating;
        if (this.getRegenerationsLeft() > RegenConfig.regenCapacity && !RegenConfig.infiniteRegeneration) {
            this.regenerationsLeft = RegenConfig.regenCapacity;
            RegenerationMod.LOG.info("Correcting the amount of Regenerations {} has", (Object)this.player.func_70005_c_());
        }
        DnaHandler.getDnaEntry(this.getDnaType()).onUpdate(this);
        if (!this.player.field_70170_p.field_72995_K && this.state != PlayerUtil.RegenState.ALIVE) {
            this.stateManager.tick();
        }
        if (this.state == PlayerUtil.RegenState.REGENERATING) {
            TypeHandler.getTypeInstance(this.regenType).onUpdateMidRegen(this.player, this);
        }
    }

    @Override
    public void synchronise() {
        if (this.player.field_70170_p.field_72995_K) {
            throw new IllegalStateException("Don't sync client -> server");
        }
        this.handsAreGlowingClient = this.state.isGraceful() && this.stateManager.handGlowTimer.getTransition() == PlayerUtil.RegenState.Transition.HAND_GLOW_TRIGGER;
        NBTTagCompound nbt = this.serializeNBT();
        nbt.func_82580_o("stateManager");
        NetworkHandler.INSTANCE.sendToAll((IMessage)new MessageSynchroniseRegeneration(this.player, nbt));
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("state", this.state.toString());
        nbt.func_74768_a("regenerationsLeft", this.regenerationsLeft);
        nbt.func_74782_a("style", (NBTBase)this.getStyle());
        if (this.regenType != null) {
            nbt.func_74778_a("type_id", this.regenType.name());
        } else {
            this.regenType = TypeHandler.RegenType.FIERY;
        }
        nbt.func_74778_a("base64_skin", this.BASE64_SKIN);
        nbt.func_74778_a("skinType", this.skinType.name());
        nbt.func_74778_a("preferredModel", this.preferredModel.name());
        nbt.func_74757_a("handsAreGlowing", this.handsAreGlowingClient);
        if (this.traitLocation != null) {
            nbt.func_74778_a("regen_dna", this.traitLocation.toString());
        } else {
            nbt.func_74778_a("regen_dna", DnaHandler.DNA_BORING.getRegistryName().toString());
        }
        nbt.func_74757_a("traitActive", this.traitActive);
        nbt.func_74768_a("ticks_animating", this.ticksAnimating);
        nbt.func_74757_a("jar", this.syncingToJar);
        if (!this.player.field_70170_p.field_72995_K) {
            nbt.func_74782_a("stateManager", (NBTBase)this.stateManager.serializeNBT());
        }
        nbt.func_74778_a("nextSkin", this.BASE64_SKIN_NEXT);
        nbt.func_74778_a("nextSkinType", this.nextSkinType.name());
        nbt.func_74757_a("handDropped", this.handDropped);
        nbt.func_74778_a("cutOffhand", this.cutOffHand.name());
        nbt.func_74776_a("progress", this.progress);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.regenerationsLeft = Math.min(RegenConfig.regenCapacity, nbt.func_74762_e(nbt.func_74764_b("livesLeft") ? "livesLeft" : "regenerationsLeft"));
        if (nbt.func_74764_b("skinType")) {
            this.setSkinType(nbt.func_74779_i("skinType"));
        }
        if (nbt.func_74764_b("progress")) {
            this.setProgress(nbt.func_74760_g("progress"));
        }
        if (nbt.func_74764_b("preferredModel")) {
            this.setPreferredModel(nbt.func_74779_i("preferredModel"));
        } else {
            this.setPreferredModel("EITHER");
        }
        this.nextSkinType = SkinInfo.SkinType.valueOf(nbt.func_74779_i("nextSkinType"));
        this.BASE64_SKIN_NEXT = nbt.func_74779_i("nextSkin");
        if (nbt.func_74764_b("regenerationsLeft")) {
            this.regenerationsLeft = nbt.func_74762_e("regenerationsLeft");
        }
        if (nbt.func_74764_b("traitActive")) {
            this.setDnaActive(nbt.func_74767_n("traitAlive"));
        } else {
            this.setDnaActive(true);
        }
        if (nbt.func_74764_b("regen_dna")) {
            this.setDnaType(new ResourceLocation(nbt.func_74779_i("regen_dna")));
        } else {
            this.setDnaType(DnaHandler.DNA_BORING.getRegistryName());
        }
        if (nbt.func_74764_b("handsAreGlowing")) {
            this.handsAreGlowingClient = nbt.func_74767_n("handsAreGlowing");
        }
        if (nbt.func_74764_b("ticks_animating")) {
            this.ticksAnimating = nbt.func_74762_e("ticks_animating");
        }
        this.setStyle(nbt.func_74764_b("style") ? nbt.func_74775_l("style") : nbt);
        this.regenType = nbt.func_74764_b("type_id") ? TypeHandler.RegenType.valueOf(nbt.func_74779_i("type_id")) : TypeHandler.RegenType.FIERY;
        this.state = nbt.func_74764_b("state") ? PlayerUtil.RegenState.valueOf(nbt.func_74779_i("state")) : PlayerUtil.RegenState.ALIVE;
        this.setEncodedSkin(nbt.func_74779_i("base64_skin"));
        if (nbt.func_74764_b("stateManager") && this.stateManager != null) {
            this.stateManager.deserializeNBT(nbt.func_74775_l("stateManager"));
        }
        if (nbt.func_74764_b("jar")) {
            this.syncingToJar = nbt.func_74767_n("jar");
        }
        if (nbt.func_74764_b("handDropped")) {
            this.handDropped = nbt.func_74767_n("handDropped");
        }
        if (nbt.func_74764_b("cutOffHand")) {
            this.cutOffHand = EnumHandSide.valueOf((String)nbt.func_74779_i("cutOffhand"));
        }
    }

    @Override
    public int getRegenerationsLeft() {
        return this.regenerationsLeft;
    }

    @Override
    @Deprecated
    public void setRegenerationsLeft(int amount) {
        this.regenerationsLeft = amount;
    }

    @Override
    public EntityPlayer getPlayer() {
        return this.player;
    }

    @Override
    public TypeHandler.RegenType getType() {
        return this.regenType;
    }

    @Override
    public void setType(TypeHandler.RegenType type) {
        this.regenType = type;
    }

    @Override
    public String getEncodedSkin() {
        return this.BASE64_SKIN;
    }

    @Override
    public void setEncodedSkin(String string) {
        this.BASE64_SKIN = string;
    }

    @Override
    public NBTTagCompound getStyle() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74776_a("PrimaryRed", this.primaryRed);
        nbt.func_74776_a("PrimaryGreen", this.primaryGreen);
        nbt.func_74776_a("PrimaryBlue", this.primaryBlue);
        nbt.func_74776_a("SecondaryRed", this.secondaryRed);
        nbt.func_74776_a("SecondaryGreen", this.secondaryGreen);
        nbt.func_74776_a("SecondaryBlue", this.secondaryBlue);
        return nbt;
    }

    @Override
    public void setStyle(NBTTagCompound nbt) {
        this.primaryRed = nbt.func_74760_g("PrimaryRed");
        this.primaryGreen = nbt.func_74760_g("PrimaryGreen");
        this.primaryBlue = nbt.func_74760_g("PrimaryBlue");
        this.secondaryRed = nbt.func_74760_g("SecondaryRed");
        this.secondaryGreen = nbt.func_74760_g("SecondaryGreen");
        this.secondaryBlue = nbt.func_74760_g("SecondaryBlue");
    }

    @Override
    public Vec3d getPrimaryColor() {
        return new Vec3d((double)this.primaryRed, (double)this.primaryGreen, (double)this.primaryBlue);
    }

    @Override
    public Vec3d getSecondaryColor() {
        return new Vec3d((double)this.secondaryRed, (double)this.secondaryGreen, (double)this.secondaryBlue);
    }

    @Override
    public void receiveRegenerations(int amount) {
        this.regenerationsLeft = RegenConfig.infiniteRegeneration ? RegenConfig.regenCapacity : (this.regenerationsLeft += amount);
        this.synchronise();
    }

    @Override
    public void extractRegeneration(int amount) {
        this.regenerationsLeft = RegenConfig.infiniteRegeneration ? RegenConfig.regenCapacity : (this.regenerationsLeft -= amount);
        this.synchronise();
    }

    @Override
    public SkinInfo.SkinType getSkinType() {
        return this.skinType;
    }

    @Override
    public void setSkinType(String skinType) {
        this.skinType = SkinInfo.SkinType.valueOf(skinType);
        if (!this.player.field_70170_p.field_72995_K) {
            this.synchronise();
        }
    }

    @Override
    public SkinChangingHandler.EnumChoices getPreferredModel() {
        return this.preferredModel;
    }

    @Override
    public void setPreferredModel(String skinType) {
        this.preferredModel = SkinChangingHandler.EnumChoices.valueOf(skinType);
    }

    @Override
    public boolean areHandsGlowing() {
        return this.handsAreGlowingClient;
    }

    @Override
    public String getDeathSource() {
        return this.deathSource;
    }

    @Override
    public void setDeathSource(String source) {
        this.deathSource = source;
    }

    @Override
    public ResourceLocation getDnaType() {
        return this.traitLocation;
    }

    @Override
    public void setDnaType(ResourceLocation resgitryName) {
        this.traitLocation = resgitryName;
    }

    @Override
    public boolean isDnaActive() {
        return this.traitActive;
    }

    @Override
    public void setDnaActive(boolean alive) {
        this.traitActive = alive;
    }

    @Override
    public int getAnimationTicks() {
        return this.ticksAnimating;
    }

    @Override
    public void setAnimationTicks(int ticks) {
        this.ticksAnimating = ticks;
    }

    @Override
    public void setSyncingFromJar(boolean syncing) {
        this.syncingToJar = syncing;
    }

    @Override
    public boolean isSyncingToJar() {
        return this.syncingToJar;
    }

    @Override
    public String getNextSkin() {
        return this.BASE64_SKIN_NEXT;
    }

    @Override
    public void setNextSkin(String base64) {
        this.BASE64_SKIN_NEXT = base64;
    }

    @Override
    public SkinInfo.SkinType getNextSkinType() {
        return this.nextSkinType;
    }

    @Override
    public void setNextSkinType(SkinInfo.SkinType skinType) {
        this.nextSkinType = skinType;
    }

    @Override
    public boolean hasDroppedHand() {
        return this.handDropped;
    }

    @Override
    public void setDroppedHand(boolean droppedHand) {
        this.handDropped = droppedHand;
    }

    @Override
    public EnumHandSide getCutoffHand() {
        return this.cutOffHand;
    }

    @Override
    public void setCutOffHand(EnumHandSide side) {
        this.cutOffHand = side;
    }

    @Override
    public float getProgress() {
        return this.progress;
    }

    @Override
    public void setProgress(float progress) {
        this.progress = progress;
    }

    @Override
    public IRegenerationStateManager getStateManager() {
        return this.stateManager;
    }

    @Override
    public PlayerUtil.RegenState getState() {
        return this.state;
    }

    @Override
    public void triggerRegeneration() {
        if (this.player.field_70170_p.field_72995_K) {
            throw new IllegalStateException("Triggering regeneration via capability instance on the client side");
        }
        this.stateManager.triggerRegeneration();
    }

    public class RegenerationStateManager
    implements IRegenerationStateManager {
        private final Map<PlayerUtil.RegenState.Transition, Runnable> transitionCallbacks = new HashMap<PlayerUtil.RegenState.Transition, Runnable>();
        private DebuggableScheduledAction nextTransition;
        private DebuggableScheduledAction handGlowTimer;

        private RegenerationStateManager() {
            this.transitionCallbacks.put(PlayerUtil.RegenState.Transition.ENTER_CRITICAL, this::enterCriticalPhase);
            this.transitionCallbacks.put(PlayerUtil.RegenState.Transition.CRITICAL_DEATH, this::midSequenceKill);
            this.transitionCallbacks.put(PlayerUtil.RegenState.Transition.FINISH_REGENERATION, this::finishRegeneration);
            this.transitionCallbacks.put(PlayerUtil.RegenState.Transition.END_POST, this::endPost);
            Runnable err = () -> {
                throw new IllegalStateException("Can't use HAND_GLOW_* transitions as state transitions");
            };
            this.transitionCallbacks.put(PlayerUtil.RegenState.Transition.HAND_GLOW_START, err);
            this.transitionCallbacks.put(PlayerUtil.RegenState.Transition.HAND_GLOW_TRIGGER, err);
        }

        private void scheduleTransitionInTicks(PlayerUtil.RegenState.Transition transition, long inTicks) {
            if (this.nextTransition != null && this.nextTransition.getTicksLeft() > 0L) {
                throw new IllegalStateException("Overwriting non-completed/cancelled transition: \n Attempted Transition: " + transition.name() + "\n Current: " + this.nextTransition.transition.name() + "\n Affected Player: " + CapabilityRegeneration.this.player.func_70005_c_());
            }
            if (transition == PlayerUtil.RegenState.Transition.HAND_GLOW_START || transition == PlayerUtil.RegenState.Transition.HAND_GLOW_TRIGGER) {
                throw new IllegalStateException("Can't use HAND_GLOW_* transitions as state transitions");
            }
            this.nextTransition = new DebuggableScheduledAction(transition, CapabilityRegeneration.this.player, this.transitionCallbacks.get((Object)transition), inTicks);
        }

        private void scheduleTransitionInSeconds(PlayerUtil.RegenState.Transition transition, long inSeconds) {
            this.scheduleTransitionInTicks(transition, inSeconds * 20L);
        }

        private void scheduleNextHandGlow() {
            if (CapabilityRegeneration.this.state.isGraceful() && this.handGlowTimer.getTicksLeft() > 0L) {
                throw new IllegalStateException("Overwriting running hand-glow timer with new next hand glow");
            }
            this.handGlowTimer = new DebuggableScheduledAction(PlayerUtil.RegenState.Transition.HAND_GLOW_START, CapabilityRegeneration.this.player, this::scheduleHandGlowTrigger, RegenConfig.grace.handGlowInterval * 20);
            CapabilityRegeneration.this.synchronise();
        }

        private void scheduleHandGlowTrigger() {
            if (CapabilityRegeneration.this.state.isGraceful() && this.handGlowTimer.getTicksLeft() > 0L) {
                throw new IllegalStateException("Overwriting running hand-glow timer with trigger timer prematurely");
            }
            this.handGlowTimer = new DebuggableScheduledAction(PlayerUtil.RegenState.Transition.HAND_GLOW_TRIGGER, CapabilityRegeneration.this.player, this::triggerRegeneration, RegenConfig.grace.handGlowTriggerDelay * 20);
            ActingForwarder.onHandsStartGlowing(CapabilityRegeneration.this);
            CapabilityRegeneration.this.synchronise();
        }

        @Override
        public boolean onKilled(DamageSource source) {
            if (source == DamageSource.field_76368_d || source == DamageSource.field_191291_g) {
                return false;
            }
            if (CapabilityRegeneration.this.state == PlayerUtil.RegenState.ALIVE) {
                if (!CapabilityRegeneration.this.canRegenerate()) {
                    return false;
                }
                this.scheduleTransitionInSeconds(PlayerUtil.RegenState.Transition.ENTER_CRITICAL, RegenConfig.grace.gracePhaseLength);
                this.scheduleHandGlowTrigger();
                CapabilityRegeneration.this.state = PlayerUtil.RegenState.GRACE;
                CapabilityRegeneration.this.synchronise();
                ActingForwarder.onEnterGrace(CapabilityRegeneration.this);
                return true;
            }
            if (CapabilityRegeneration.this.state == PlayerUtil.RegenState.GRACE) {
                this.triggerRegeneration();
                return true;
            }
            if (CapabilityRegeneration.this.state == PlayerUtil.RegenState.REGENERATING) {
                this.nextTransition.cancel();
                this.midSequenceKill();
                return false;
            }
            if (CapabilityRegeneration.this.state == PlayerUtil.RegenState.POST) {
                CapabilityRegeneration.this.state = PlayerUtil.RegenState.ALIVE;
                this.nextTransition.cancel();
                this.midSequenceKill();
                return false;
            }
            if (CapabilityRegeneration.this.state == PlayerUtil.RegenState.GRACE_CRIT) {
                this.nextTransition.cancel();
                this.midSequenceKill();
                return false;
            }
            throw new IllegalStateException("Unknown state: " + (Object)((Object)CapabilityRegeneration.this.state));
        }

        @Override
        public void onPunchEntity(LivingHurtEvent event) {
            EntityLivingBase entity = event.getEntityLiving();
            if (CapabilityRegeneration.this.state.isGraceful() && entity.func_110143_aJ() < entity.func_110138_aP() && CapabilityRegeneration.this.areHandsGlowing() && CapabilityRegeneration.this.player.func_70093_af()) {
                float healthNeeded = entity.func_110138_aP() - entity.func_110143_aJ();
                entity.func_70691_i(healthNeeded);
                PlayerUtil.sendMessage(CapabilityRegeneration.this.player, new TextComponentTranslation("message.regeneration.healed", new Object[]{entity.func_70005_c_()}), true);
                event.setAmount(0.0f);
                CapabilityRegeneration.this.player.func_70097_a(RegenObjects.REGEN_DMG_HEALING, healthNeeded);
            }
        }

        @Override
        public void onPunchBlock(PlayerInteractEvent.LeftClickBlock e) {
            if (CapabilityRegeneration.this.getState().isGraceful() && CapabilityRegeneration.this.areHandsGlowing()) {
                IBlockState block = e.getWorld().func_180495_p(e.getPos());
                if (block.func_177230_c() == Blocks.field_150433_aE || block.func_177230_c() == Blocks.field_150431_aC) {
                    e.getWorld().func_184133_a(null, e.getPos(), SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                if (block.func_177230_c() instanceof BlockHandInJar) {
                    TileEntityHandInJar handInJar = (TileEntityHandInJar)e.getWorld().func_175625_s(e.getPos());
                    handInJar.setLindosAmont(handInJar.getLindosAmont() + e.getWorld().field_73012_v.nextInt(10));
                }
                this.handGlowTimer.cancel();
                this.scheduleNextHandGlow();
                if (!((CapabilityRegeneration)CapabilityRegeneration.this).player.field_70170_p.field_72995_K) {
                    RegenTriggers.CHANGE_REFUSAL.trigger((EntityPlayerMP)CapabilityRegeneration.this.player);
                    PlayerUtil.sendMessage(CapabilityRegeneration.this.player, new TextComponentTranslation("regeneration.messages.regen_delayed", new Object[0]), true);
                }
                e.setCanceled(true);
            }
        }

        private void tick() {
            if (((CapabilityRegeneration)CapabilityRegeneration.this).player.field_70170_p.field_72995_K) {
                throw new IllegalStateException("Ticking state manager on the client");
            }
            if (CapabilityRegeneration.this.state == PlayerUtil.RegenState.ALIVE) {
                throw new IllegalStateException("Ticking dormant state manager (state == ALIVE)");
            }
            if (CapabilityRegeneration.this.state.isGraceful()) {
                this.handGlowTimer.tick();
            }
            ActingForwarder.onRegenTick(CapabilityRegeneration.this);
            this.nextTransition.tick();
        }

        private void triggerRegeneration() {
            CapabilityRegeneration.this.state = PlayerUtil.RegenState.REGENERATING;
            if (RegenConfig.sendRegenDeathMessages) {
                TextComponentTranslation text = new TextComponentTranslation("regeneration.messages.regen_chat_message", new Object[]{CapabilityRegeneration.this.player.func_70005_c_()});
                text.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString(CapabilityRegeneration.this.getDeathSource())));
                PlayerUtil.sendMessageToAll(text);
            }
            this.nextTransition.cancel();
            if (CapabilityRegeneration.this.state.isGraceful()) {
                this.handGlowTimer.cancel();
            }
            this.scheduleTransitionInTicks(PlayerUtil.RegenState.Transition.FINISH_REGENERATION, TypeHandler.getTypeInstance(CapabilityRegeneration.this.regenType).getAnimationLength());
            ActingForwarder.onRegenTrigger(CapabilityRegeneration.this);
            TypeHandler.getTypeInstance(CapabilityRegeneration.this.regenType).onStartRegeneration(CapabilityRegeneration.this.player, CapabilityRegeneration.this);
            CapabilityRegeneration.this.synchronise();
        }

        private void enterCriticalPhase() {
            CapabilityRegeneration.this.state = PlayerUtil.RegenState.GRACE_CRIT;
            this.scheduleTransitionInSeconds(PlayerUtil.RegenState.Transition.CRITICAL_DEATH, RegenConfig.grace.criticalPhaseLength);
            ActingForwarder.onGoCritical(CapabilityRegeneration.this);
            CapabilityRegeneration.this.synchronise();
        }

        private void midSequenceKill() {
            if (CapabilityRegeneration.this.state == PlayerUtil.RegenState.GRACE_CRIT) {
                CapabilityRegeneration.this.player.func_70097_a(RegenObjects.REGEN_DMG_CRITICAL, 2.1474836E9f);
            } else {
                CapabilityRegeneration.this.player.func_70097_a(RegenObjects.REGEN_DMG_KILLED, 2.1474836E9f);
            }
            CapabilityRegeneration.this.state = PlayerUtil.RegenState.ALIVE;
            this.nextTransition = null;
            this.handGlowTimer = null;
            TypeHandler.getTypeInstance(CapabilityRegeneration.this.regenType).onFinishRegeneration(CapabilityRegeneration.this.player, CapabilityRegeneration.this);
            CapabilityRegeneration.this.synchronise();
            ActingForwarder.onProcessDone(CapabilityRegeneration.this);
        }

        private void finishRegeneration() {
            CapabilityRegeneration.this.state = PlayerUtil.RegenState.POST;
            ActingForwarder.onStartPost(CapabilityRegeneration.this);
            this.scheduleTransitionInSeconds(PlayerUtil.RegenState.Transition.END_POST, RegenConfig.postRegen.postRegenerationDuration);
            this.handGlowTimer = null;
            TypeHandler.getTypeInstance(CapabilityRegeneration.this.regenType).onFinishRegeneration(CapabilityRegeneration.this.player, CapabilityRegeneration.this);
            ActingForwarder.onRegenFinish(CapabilityRegeneration.this);
            CapabilityRegeneration.this.synchronise();
        }

        private void endPost() {
            CapabilityRegeneration.this.state = PlayerUtil.RegenState.ALIVE;
            CapabilityRegeneration.this.synchronise();
            this.nextTransition = null;
            PlayerUtil.sendMessage(CapabilityRegeneration.this.player, new TextComponentTranslation("regeneration.messages.post_ended", new Object[0]), true);
            ActingForwarder.onProcessDone(CapabilityRegeneration.this);
        }

        @Override
        @Deprecated
        public Pair<PlayerUtil.RegenState.Transition, Long> getScheduledEvent() {
            return this.nextTransition == null ? null : Pair.of((Object)((Object)this.nextTransition.transition), (Object)this.nextTransition.getTicksLeft());
        }

        @Override
        @Deprecated
        public void fastForward() {
            while (!this.nextTransition.tick()) {
            }
        }

        @Override
        @Deprecated
        public void fastForwardHandGlow() {
            while (!this.handGlowTimer.tick()) {
            }
        }

        @Override
        public double getStateProgress() {
            return this.nextTransition.getProgress();
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            if (this.nextTransition != null && this.nextTransition.getTicksLeft() >= 0L) {
                nbt.func_74778_a("transitionId", this.nextTransition.transition.toString());
                nbt.func_74772_a("transitionInTicks", this.nextTransition.getTicksLeft());
            }
            if (this.handGlowTimer != null && this.handGlowTimer.getTicksLeft() >= 0L) {
                nbt.func_74778_a("handGlowState", this.handGlowTimer.transition.toString());
                nbt.func_74772_a("handGlowScheduledTicks", this.handGlowTimer.getTicksLeft());
            }
            return nbt;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            if (nbt.func_74764_b("transitionId")) {
                this.scheduleTransitionInTicks(PlayerUtil.RegenState.Transition.valueOf(nbt.func_74779_i("transitionId")), nbt.func_74763_f("transitionInTicks"));
            }
            if (nbt.func_74764_b("handGlowState")) {
                Runnable callback;
                PlayerUtil.RegenState.Transition transition = PlayerUtil.RegenState.Transition.valueOf(nbt.func_74779_i("handGlowState"));
                if (transition == PlayerUtil.RegenState.Transition.HAND_GLOW_START) {
                    callback = this::scheduleHandGlowTrigger;
                } else if (transition == PlayerUtil.RegenState.Transition.HAND_GLOW_TRIGGER) {
                    callback = this::triggerRegeneration;
                } else {
                    throw new IllegalStateException("Illegal hand glow timer transition");
                }
                this.handGlowTimer = new DebuggableScheduledAction(transition, CapabilityRegeneration.this.player, callback, nbt.func_74763_f("handGlowScheduledTicks"));
            }
        }
    }
}

